/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.function.Supplier;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.client.editor.GuidedRuleTemplateEditorPresenter;
import org.drools.workbench.screens.guided.template.client.editor.GuidedRuleTemplateEditorView;
import org.drools.workbench.screens.guided.template.model.GuidedTemplateEditorContent;
import org.drools.workbench.screens.guided.template.service.GuidedRuleTemplateEditorService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={CommandDrivenErrorCallback.class})
public class GuidedRuleTemplateEditorPresenterTest {
    @Mock
    private AsyncPackageDataModelOracleFactory oracleFactory;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private ObservablePath path;
    @Mock
    private KieEditorWrapperView kieView;
    @Mock
    private OverviewWidgetPresenter overviewPresenter;
    @Mock
    private ImportsWidgetPresenter importsWidgetPresenter;
    @Mock
    private GuidedRuleTemplateEditorView view;
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private GuidedRuleTemplateEditorService service;
    @Mock
    private Overview overview;
    @Mock
    private TemplateModel templateModel;
    @Mock
    private PackageDataModelOracleBaselinePayload payload;
    @Mock
    private GuidedTemplateEditorContent content;
    private Caller<GuidedRuleTemplateEditorService> serviceCaller;
    @Spy
    @InjectMocks
    private GuidedRuleTemplateEditorPresenter presenter;

    public GuidedRuleTemplateEditorPresenterTest() {
        this.presenter = new GuidedRuleTemplateEditorPresenter(this.view);
    }

    @Before
    public void setUp() throws Exception {
        ((GuidedTemplateEditorContent)Mockito.doReturn((Object)this.templateModel).when((Object)this.content)).getModel();
        ((GuidedTemplateEditorContent)Mockito.doReturn((Object)this.overview).when((Object)this.content)).getOverview();
        ((GuidedTemplateEditorContent)Mockito.doReturn((Object)this.payload).when((Object)this.content)).getDataModel();
        this.serviceCaller = new CallerMock((Object)this.service);
        ((GuidedRuleTemplateEditorPresenter)Mockito.doReturn(this.serviceCaller).when((Object)this.presenter)).getService();
        ((AsyncPackageDataModelOracleFactory)Mockito.doReturn((Object)this.oracle).when((Object)this.oracleFactory)).makeAsyncPackageDataModelOracle((Path)this.path, (HasImports)this.templateModel, this.payload);
        ((VersionRecordManager)Mockito.doReturn((Object)this.path).when((Object)this.versionRecordManager)).getCurrentPath();
    }

    @Test
    public void testLoadContentSuccess() throws Exception {
        ((GuidedRuleTemplateEditorService)Mockito.doReturn((Object)this.content).when((Object)this.service)).loadContent((Path)Matchers.eq((Object)this.path));
        this.presenter.loadContent();
        ((GuidedRuleTemplateEditorView)Mockito.verify((Object)this.view)).setContent((TemplateModel)Matchers.eq((Object)this.templateModel), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle), (Caller)Matchers.any(), (EventBus)Matchers.notNull(EventBus.class), Matchers.eq((boolean)false));
    }

    @Test
    public void testLoadContentFail() throws Exception {
        ((GuidedRuleTemplateEditorService)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.service)).loadContent((Path)Matchers.eq((Object)this.path));
        this.presenter.loadContent();
        ((GuidedRuleTemplateEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setContent((TemplateModel)Matchers.any(TemplateModel.class), (AsyncPackageDataModelOracle)Matchers.any(AsyncPackageDataModelOracle.class), (Caller)Matchers.any(Caller.class), (EventBus)Matchers.any(EventBus.class), Matchers.anyBoolean());
    }

    @Test
    public void testGetContentSupplier() throws Exception {
        TemplateModel content = (TemplateModel)Mockito.mock(TemplateModel.class);
        ((GuidedRuleTemplateEditorPresenter)Mockito.doReturn((Object)content).when((Object)this.presenter)).getModel();
        Supplier contentSupplier = this.presenter.getContentSupplier();
        Assert.assertEquals((Object)content, contentSupplier.get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() throws Exception {
        Caller serviceCaller = this.presenter.getSaveAndRenameServiceCaller();
        Assert.assertEquals(this.serviceCaller, (Object)serviceCaller);
    }
}

