/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataColumn;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDropDownManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@WithClassesToStub(value={DateTimeFormat.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class TemplateDataCellFactoryTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private TemplateDropDownManager dropDownManager;
    private boolean isReadOnly = false;
    @Mock
    private EventBus eventBus;
    @Mock
    private TemplateDataColumn column;
    private TemplateDataCellFactory testedFactory;

    @Before
    public void setUp() throws Exception {
        this.testedFactory = (TemplateDataCellFactory)Mockito.spy((Object)new TemplateDataCellFactory(this.oracle, this.dropDownManager, this.isReadOnly, this.eventBus));
    }

    @Test
    public void testGetCell() throws Exception {
        String factType = "org.kiegroup.Car";
        String factField = "color";
        String dataType = DataType.DataTypes.STRING.name();
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"color").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)dataType).when((Object)this.column)).getDataType();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeSingleSelectionEnumCell("org.kiegroup.Car", "color", dataType);
    }

    @Test
    public void testGetCellWhenEnumPresent() throws Exception {
        String factType = "org.kiegroup.Car";
        String factField = "color";
        String dataType = DataType.DataTypes.STRING.name();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)true).when((Object)this.oracle)).hasEnums("org.kiegroup.Car", "color");
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"color").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)dataType).when((Object)this.column)).getDataType();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).makeSingleSelectionEnumCell("org.kiegroup.Car", "color", dataType);
    }
}

