/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.project.ProjectFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;

@ApplicationScoped
public class DeleteProjectObserverBridge {
    private IOService ioService;
    private ProjectFactory<? extends Project> projectFactory;
    private Event<DeleteProjectEvent> deleteProjectEvent;

    public DeleteProjectObserverBridge() {
    }

    @Inject
    public DeleteProjectObserverBridge(@Named(value="ioStrategy") IOService ioService, ProjectFactory<? extends Project> projectFactory, Event<DeleteProjectEvent> deleteProjectEvent) {
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.projectFactory = (ProjectFactory)PortablePreconditions.checkNotNull((String)"projectFactory", projectFactory);
        this.deleteProjectEvent = (Event)PortablePreconditions.checkNotNull((String)"deleteProjectEvent", deleteProjectEvent);
    }

    public void onBatchResourceChanges(@Observes ResourceDeletedEvent event) {
        if (event.getPath().getFileName().equals("pom.xml")) {
            this.fireDeleteEvent(event.getPath());
        }
    }

    public void onBatchResourceChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        for (Map.Entry entry : resourceBatchChangesEvent.getBatch().entrySet()) {
            if (!((org.uberfire.backend.vfs.Path)entry.getKey()).getFileName().equals("pom.xml") || !this.isDelete((Collection)entry.getValue())) continue;
            this.fireDeleteEvent((org.uberfire.backend.vfs.Path)entry.getKey());
        }
    }

    private boolean isDelete(Collection<ResourceChange> value) {
        for (ResourceChange resourceChange : value) {
            if (!(resourceChange instanceof ResourceDeleted)) continue;
            return true;
        }
        return false;
    }

    private void fireDeleteEvent(org.uberfire.backend.vfs.Path _path) {
        Path path = this.ioService.get(URI.create(_path.toURI()));
        Project project = this.projectFactory.simpleProjectInstance(path.getParent());
        this.deleteProjectEvent.fire((Object)new DeleteProjectEvent(project));
    }
}

