/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml;

public class XMLStringBuilder {
    private static final String LT = "<";
    private static final String LT_SLASH = "</";
    private static final String GT = ">";
    private StringBuilder sb = new StringBuilder();
    private String newLine = System.getProperty("line.separator");
    private int indent = 0;

    public XMLStringBuilder startTag(String tagName) {
        if (tagName == null) {
            throw new NullPointerException("No tag name specified");
        }
        this.printIndent();
        this.sb.append(LT).append(tagName).append(GT);
        return this;
    }

    public XMLStringBuilder printTagContent(String tagContent) {
        this.sb.append(tagContent);
        return this;
    }

    public XMLStringBuilder endTag(String tagName) {
        if (tagName == null) {
            throw new NullPointerException("No tag name specified");
        }
        this.printIndent();
        this.sb.append(LT_SLASH).append(tagName).append(GT);
        return this;
    }

    public XMLStringBuilder newLine() {
        this.sb.append(this.newLine);
        return this;
    }

    public XMLStringBuilder indent() {
        ++this.indent;
        return this;
    }

    public XMLStringBuilder unIndent() {
        --this.indent;
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append("  ");
        }
    }
}

