/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.CategoryPageRow;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.builder.pagerow.CategoryRuleListPageRowBuilder;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.util.HtmlCleaner;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.security.Identity;

@ApplicationScoped
public class RepositoryCategoryOperations {
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryCategoryOperations.class);
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private ServiceSecurity serviceSecurity;
    @Inject
    private Identity identity;

    @Deprecated
    public void setRulesRepositoryForTest(RulesRepository repository) {
        this.rulesRepository = repository;
    }

    protected String[] loadChildCategories(String categoryPath) {
        ArrayList<String> resultList = new ArrayList<String>();
        CategoryFilter filter = new CategoryFilter(this.identity);
        CategoryItem item = this.rulesRepository.loadCategory(categoryPath);
        List children = item.getChildTags();
        for (Object aChildren : children) {
            String childCategoryName = ((CategoryItem)aChildren).getName();
            if (!filter.acceptNavigate(categoryPath, childCategoryName)) continue;
            resultList.add(childCategoryName);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    protected Boolean createCategory(String path, String name, String description) {
        log.info("USER:" + this.getCurrentUserName() + " CREATING category: [" + name + "] in path [" + path + "]");
        if (path == null || "".equals(path)) {
            path = "/";
        }
        path = HtmlCleaner.cleanHTML(path);
        this.rulesRepository.loadCategory(path).addCategory(name, description);
        this.rulesRepository.save();
        return Boolean.TRUE;
    }

    protected void renameCategory(String fullPathAndName, String newName) {
        this.rulesRepository.renameCategory(fullPathAndName, newName);
    }

    protected TableDataResult loadRuleListForCategories(String categoryPath, int skip, int numRows, String tableConfig) throws SerializationException {
        if (!this.serviceSecurity.hasPermissionAnalystReadWithCategoryPathType(categoryPath)) {
            TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
            return handler.loadRuleListTable(new AssetItemPageResult());
        }
        AssetItemPageResult result = this.rulesRepository.findAssetsByCategory(categoryPath, false, skip, numRows);
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        return handler.loadRuleListTable(result);
    }

    protected PageResponse<CategoryPageRow> loadRuleListForCategories(CategoryPageRequest request) {
        long start = System.currentTimeMillis();
        int numRowsToReturn = request.getPageSize() == null ? -1 : request.getPageSize();
        AssetItemPageResult result = this.rulesRepository.findAssetsByCategory(request.getCategoryPath(), false, request.getStartRowIndex(), numRowsToReturn);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        boolean hasMoreRows = result.hasNext;
        List<CategoryPageRow> rowList = new CategoryRuleListPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(result.assets.iterator()).build();
        PageResponse<CategoryPageRow> pageResponse = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!hasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Assest with Category (" + request.getCategoryPath() + ") in " + methodDuration + " ms.");
        return pageResponse;
    }

    protected void removeCategory(String categoryPath) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " REMOVING CATEGORY path: [" + categoryPath + "]");
        try {
            this.rulesRepository.loadCategory(categoryPath).remove();
            this.rulesRepository.save();
        }
        catch (RulesRepositoryException e) {
            log.info("Unable to remove category [" + categoryPath + "]. It is probably still used: " + e.getMessage());
            throw new DetailedSerializationException("Unable to remove category. It is probably still used.", e.getMessage());
        }
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }
}

