/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.commons.backend.oracle.ProjectDataModelOracleImpl;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.BaseFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassFieldInspector;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassMethodInspector;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassToGenericClassConverter;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.JavaTypeSystemTranslator;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.AnnotationUtils;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.BlackLists;

public class ClassFactBuilder
extends BaseFactBuilder {
    private final ClassToGenericClassConverter typeSystemConverter = new JavaTypeSystemTranslator();
    private final Map<String, List<MethodInfo>> methodInformation = new HashMap<String, List<MethodInfo>>();
    private final Map<String, String> fieldParametersType = new HashMap<String, String>();
    private final List<String> superTypes;
    private final Set<org.drools.workbench.models.datamodel.oracle.Annotation> annotations = new LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation>();
    private final Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> fieldAnnotations = new HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>();
    private final Map<String, FactBuilder> fieldFactBuilders = new HashMap<String, FactBuilder>();

    public ClassFactBuilder(ProjectDataModelOracleBuilder builder, Class<?> clazz, boolean isEvent, TypeSource typeSource) throws IOException {
        this(builder, new HashMap<String, FactBuilder>(), clazz, isEvent, typeSource);
    }

    public ClassFactBuilder(ProjectDataModelOracleBuilder builder, Map<String, FactBuilder> discoveredFieldFactBuilders, Class<?> clazz, boolean isEvent, TypeSource typeSource) throws IOException {
        super(builder, clazz, isEvent, typeSource);
        this.superTypes = this.getSuperTypes(clazz);
        this.annotations.addAll(this.getAnnotations(clazz));
        this.fieldAnnotations.putAll(this.getFieldsAnnotations(clazz));
        this.loadClassFields(clazz, discoveredFieldFactBuilders);
    }

    @Override
    public void build(ProjectDataModelOracleImpl oracle) {
        super.build(oracle);
        oracle.addProjectMethodInformation(this.methodInformation);
        oracle.addProjectFieldParametersType(this.fieldParametersType);
        oracle.addProjectSuperTypes(this.buildSuperTypes());
        oracle.addProjectTypeAnnotations(this.buildTypeAnnotations());
        oracle.addProjectTypeFieldsAnnotations(this.buildTypeFieldsAnnotations());
    }

    private List<String> getSuperTypes(Class<?> clazz) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Class<?> superType = clazz.getSuperclass(); superType != null; superType = superType.getSuperclass()) {
            strings.add(superType.getName());
        }
        return strings;
    }

    protected Set<org.drools.workbench.models.datamodel.oracle.Annotation> getAnnotations(Class<?> clazz) {
        Annotation[] annotations;
        LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation> dmoAnnotations = new LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation>();
        for (Annotation a : annotations = clazz.getAnnotations()) {
            org.drools.workbench.models.datamodel.oracle.Annotation dmoa = new org.drools.workbench.models.datamodel.oracle.Annotation(a.annotationType().getName());
            for (Method m : a.annotationType().getDeclaredMethods()) {
                String methodName = m.getName();
                dmoa.addAttribute(methodName, AnnotationUtils.getAnnotationAttributeValue(a, methodName));
            }
            dmoAnnotations.add(dmoa);
        }
        return dmoAnnotations;
    }

    private Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> getFieldsAnnotations(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> fieldsAnnotations = new HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>();
        for (Field field : fields) {
            String fieldName = field.getName();
            Set<org.drools.workbench.models.datamodel.oracle.Annotation> fieldAnnotations = this.getFieldAnnotations(field);
            if (fieldAnnotations.size() <= 0) continue;
            fieldsAnnotations.put(fieldName, fieldAnnotations);
        }
        return fieldsAnnotations;
    }

    private Set<org.drools.workbench.models.datamodel.oracle.Annotation> getFieldAnnotations(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation> fieldAnnotations = new LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation>();
        for (Annotation a : annotations) {
            org.drools.workbench.models.datamodel.oracle.Annotation fieldAnnotation = new org.drools.workbench.models.datamodel.oracle.Annotation(a.annotationType().getName());
            for (Method m : a.annotationType().getDeclaredMethods()) {
                String methodName = m.getName();
                fieldAnnotation.addAttribute(methodName, AnnotationUtils.getAnnotationAttributeValue(a, methodName));
            }
            fieldAnnotations.add(fieldAnnotation);
        }
        return fieldAnnotations;
    }

    private void loadClassFields(Class<?> clazz, Map<String, FactBuilder> discoveredFieldFactBuilders) throws IOException {
        if (clazz == null) {
            return;
        }
        String factType = this.getType();
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        Set<String> fieldNames = inspector.getFieldNames();
        for (String fieldName : fieldNames) {
            ClassFieldInspector.FieldInfo f = inspector.getFieldTypesFieldInfo().get(fieldName);
            this.addParametricTypeForField(factType, fieldName, f.getGenericType());
            Class<?> returnType = f.getReturnType();
            String genericReturnType = this.typeSystemConverter.translateClassToGenericType(returnType);
            this.addField(new ModelField(fieldName, returnType.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, f.getOrigin(), f.getAccessorAndMutator(), genericReturnType));
            this.addEnumsForField(factType, fieldName, returnType);
            if (BlackLists.isReturnTypeBlackListed(returnType)) continue;
            if (!discoveredFieldFactBuilders.containsKey(genericReturnType)) {
                discoveredFieldFactBuilders.put(genericReturnType, null);
                discoveredFieldFactBuilders.put(genericReturnType, new ClassFactBuilder(this.builder, discoveredFieldFactBuilders, returnType, false, this.typeSource));
            }
            if (discoveredFieldFactBuilders.get(genericReturnType) == null) continue;
            this.fieldFactBuilders.put(genericReturnType, discoveredFieldFactBuilders.get(genericReturnType));
        }
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz, this.typeSystemConverter);
        List<MethodInfo> methodInformation = methodInspector.getMethodInfos();
        for (MethodInfo mi : methodInformation) {
            String genericType = mi.getParametricReturnType();
            if (genericType == null) continue;
            String qualifiedFactFieldName = factType + "#" + mi.getNameWithParameters();
            this.fieldParametersType.put(qualifiedFactFieldName, genericType);
        }
        this.methodInformation.put(factType, methodInformation);
    }

    private void addEnumsForField(String className, String fieldName, Class<?> fieldClazz) {
        if (fieldClazz.isEnum()) {
            Field[] enumFields = fieldClazz.getDeclaredFields();
            ArrayList<String> enumValues = new ArrayList<String>();
            for (Field enumField : enumFields) {
                if (!enumField.isEnumConstant()) continue;
                String shortName = fieldClazz.getName().substring(fieldClazz.getName().lastIndexOf(".") + 1) + "." + enumField.getName();
                if (shortName.contains("$")) {
                    shortName = shortName.replaceAll("\\$", ".");
                }
                enumValues.add(shortName + "=" + shortName);
            }
            String[] a = new String[enumValues.size()];
            enumValues.toArray(a);
            this.getDataModelBuilder().addEnum(className, fieldName, a);
        }
    }

    private void addParametricTypeForField(String className, String fieldName, Type type) {
        String qualifiedFactFieldName = className + "#" + fieldName;
        String parametricType = this.getParametricType(type);
        if (parametricType != null) {
            this.fieldParametersType.put(qualifiedFactFieldName, parametricType);
        }
    }

    private String getParametricType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type parameter = null;
            Type[] arr$ = pt.getActualTypeArguments();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Type t;
                parameter = t = arr$[i$];
            }
            if (parameter != null) {
                if (parameter instanceof Class) {
                    return ((Class)parameter).getName();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Map<String, List<String>> buildSuperTypes() {
        HashMap<String, List<String>> loadableSuperTypes = new HashMap<String, List<String>>();
        loadableSuperTypes.put(this.getType(), this.superTypes);
        return loadableSuperTypes;
    }

    private Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> buildTypeAnnotations() {
        HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> loadableTypeAnnotations = new HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>();
        loadableTypeAnnotations.put(this.getType(), this.annotations);
        return loadableTypeAnnotations;
    }

    private Map<String, Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>> buildTypeFieldsAnnotations() {
        HashMap<String, Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>> loadableTypeFieldsAnnotations = new HashMap<String, Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>>();
        loadableTypeFieldsAnnotations.put(this.getType(), this.fieldAnnotations);
        return loadableTypeFieldsAnnotations;
    }

    @Override
    public Map<String, FactBuilder> getInternalBuilders() {
        for (FactBuilder factBuilder : new ArrayList<FactBuilder>(this.fieldFactBuilders.values())) {
            this.fieldFactBuilders.putAll(factBuilder.getInternalBuilders());
        }
        return this.fieldFactBuilders;
    }
}

