/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.backend.builder.TypeSourceResolver;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListServiceImpl;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

class ProjectDataModelOracleBuilderProvider {
    private static final Logger log = LoggerFactory.getLogger(ProjectDataModelOracleBuilderProvider.class);
    private ProjectImportsService importsService;
    private PackageNameWhiteListServiceImpl packageNameWhiteListService;

    public ProjectDataModelOracleBuilderProvider() {
    }

    @Inject
    public ProjectDataModelOracleBuilderProvider(PackageNameWhiteListServiceImpl packageNameWhiteListService, ProjectImportsService importsService) {
        this.packageNameWhiteListService = packageNameWhiteListService;
        this.importsService = importsService;
    }

    public InnerBuilder newBuilder(KieProject project, Builder builder) {
        KieModuleMetaData kieModuleMetaData = builder.getKieModuleMetaDataIgnoringErrors();
        TypeSourceResolver typeSourceResolver = builder.getTypeSourceResolver(kieModuleMetaData);
        return new InnerBuilder(project, kieModuleMetaData, typeSourceResolver);
    }

    class InnerBuilder {
        private final ProjectDataModelOracleBuilder pdBuilder = ProjectDataModelOracleBuilder.newProjectOracleBuilder();
        private final KieProject project;
        private final KieModuleMetaData kieModuleMetaData;
        private final TypeSourceResolver typeSourceResolver;

        private InnerBuilder(KieProject project, KieModuleMetaData kieModuleMetaData, TypeSourceResolver typeSourceResolver) {
            this.project = project;
            this.kieModuleMetaData = kieModuleMetaData;
            this.typeSourceResolver = typeSourceResolver;
        }

        public ProjectDataModelOracle build() {
            this.addFromKieModuleMetadata();
            this.addExternalImports();
            return this.pdBuilder.build();
        }

        private void addExternalImports() {
            if (Files.exists((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.project.getImportsPath()), (LinkOption[])new LinkOption[0])) {
                for (Import item : this.getImports()) {
                    this.addClass(item);
                }
            }
        }

        private void addFromKieModuleMetadata() {
            for (String packageName : this.getFilteredPackageNames()) {
                this.pdBuilder.addPackage(packageName);
                this.addClasses(packageName, this.kieModuleMetaData.getClasses(packageName));
            }
        }

        private Set<String> getFilteredPackageNames() {
            return ProjectDataModelOracleBuilderProvider.this.packageNameWhiteListService.filterPackageNames((Project)this.project, this.kieModuleMetaData.getPackages());
        }

        private void addClasses(String packageName, Collection<String> classes) {
            for (String className : classes) {
                this.addClass(packageName, className);
            }
        }

        private void addClass(Import item) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(item.getType());
                this.pdBuilder.addClass(clazz, false, TypeSource.JAVA_DEPENDENCY);
            }
            catch (ClassNotFoundException cnfe) {
                log.debug(cnfe.getMessage());
            }
            catch (IOException ioe) {
                log.debug(ioe.getMessage());
            }
        }

        private void addClass(String packageName, String className) {
            try {
                Class clazz = this.kieModuleMetaData.getClass(packageName, className);
                this.pdBuilder.addClass(clazz, this.kieModuleMetaData.getTypeMetaInfo(clazz).isEvent(), this.typeSourceResolver.getTypeSource(clazz));
            }
            catch (Throwable e) {
                log.debug(e.getMessage());
            }
        }

        private List<Import> getImports() {
            return ((ProjectImports)ProjectDataModelOracleBuilderProvider.this.importsService.load(this.project.getImportsPath())).getImports().getImports();
        }
    }
}

