/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.PomFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.workbench.common.services.backend.validation.KModuleFileFilter;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class DefaultGenericKieValidator
implements GenericValidator {
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found. Consequentially validation cannot be performed.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private IOService ioService;
    private KieProjectService projectService;
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private final DirectoryStream.Filter<Path> kmoduleFileFilter = new KModuleFileFilter();
    private final DirectoryStream.Filter<Path> pomFileFilter = new PomFileFilter();

    @Inject
    public DefaultGenericKieValidator(@Named(value="ioStrategy") IOService ioService, KieProjectService projectService) {
        this.ioService = ioService;
        this.projectService = projectService;
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path resourcePath, InputStream resource, DirectoryStream.Filter<Path> ... supportingFileFilters) {
        Project project = this.projectService.resolveProject(resourcePath);
        if (project == null) {
            return Collections.emptyList();
        }
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        String projectPrefix = project.getRootPath().toURI();
        String destinationPath = resourcePath.toURI().substring(projectPrefix.length() + 1);
        BufferedInputStream bis = new BufferedInputStream(resource);
        kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        ResourceFilter resourceFilter = new ResourceFilter(resourcePath);
        Path nioProjectRoot = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath());
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)nioProjectRoot);
        this.visitPaths(projectPrefix, kieFileSystem, (DirectoryStream<Path>)directoryStream, resourceFilter, supportingFileFilters);
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        try {
            Results kieResults = kieBuilder.buildAll().getResults();
            String destinationBasePath = this.getBasePath(destinationPath);
            for (Message message : kieResults.getMessages()) {
                String messageBasePath;
                String string = messageBasePath = message.getPath() != null ? this.getBasePath(message.getPath()) : null;
                if (messageBasePath != null && !"".equals(messageBasePath) && !destinationBasePath.endsWith(messageBasePath)) continue;
                validationMessages.add(this.convertMessage(message));
            }
        }
        catch (NoClassDefFoundError e) {
            String msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
            validationMessages.add(this.makeErrorMessage(msg));
        }
        catch (Throwable e) {
            String msg = e.getLocalizedMessage();
            validationMessages.add(this.makeErrorMessage(msg));
        }
        return validationMessages;
    }

    private String getBasePath(String path) {
        if (path != null && path.contains(".")) {
            return path.substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private void visitPaths(String projectPrefix, KieFileSystem kieFileSystem, DirectoryStream<Path> directoryStream, ResourceFilter resourceFilter, DirectoryStream.Filter<Path> ... supportingFileFilters) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths(projectPrefix, kieFileSystem, (DirectoryStream<Path>)Files.newDirectoryStream((Path)path), resourceFilter, supportingFileFilters);
                continue;
            }
            if (!this.acceptPath(path, resourceFilter, supportingFileFilters)) continue;
            String destinationPath = path.toUri().toString().substring(projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        }
    }

    private boolean acceptPath(Path path, ResourceFilter resourceFilter, DirectoryStream.Filter<Path> ... supportingFileFilters) {
        if (this.dotFileFilter.accept((Object)path)) {
            return false;
        }
        if (this.kmoduleFileFilter.accept((Object)path)) {
            return false;
        }
        if (this.pomFileFilter.accept((Object)path)) {
            return true;
        }
        if (resourceFilter.accept(path)) {
            return false;
        }
        for (DirectoryStream.Filter<Path> filter : supportingFileFilters) {
            if (!filter.accept((Object)path)) continue;
            return true;
        }
        return false;
    }

    private ValidationMessage makeErrorMessage(String msg) {
        ValidationMessage validationMessage = new ValidationMessage();
        validationMessage.setLevel(Level.ERROR);
        validationMessage.setText(msg);
        return validationMessage;
    }

    private ValidationMessage convertMessage(Message message) {
        ValidationMessage msg = new ValidationMessage();
        switch (message.getLevel()) {
            case ERROR: {
                msg.setLevel(Level.ERROR);
                break;
            }
            case WARNING: {
                msg.setLevel(Level.WARNING);
                break;
            }
            case INFO: {
                msg.setLevel(Level.INFO);
            }
        }
        msg.setId(message.getId());
        msg.setLine(message.getLine());
        msg.setColumn(message.getColumn());
        msg.setText(message.getText());
        return msg;
    }

    private static class ResourceFilter
    implements DirectoryStream.Filter<Path> {
        private Path resourcePath;

        ResourceFilter(org.uberfire.backend.vfs.Path resourcePath) {
            this.resourcePath = Paths.convert((org.uberfire.backend.vfs.Path)((org.uberfire.backend.vfs.Path)PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath)));
        }

        public boolean accept(Path entry) throws IOException {
            return entry.equals(this.resourcePath);
        }
    }
}

