/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.validation.JavaFileNameValidator;
import org.kie.workbench.common.services.backend.validation.PackageNameValidator;
import org.kie.workbench.common.services.backend.validation.ProjectNameValidator;
import org.kie.workbench.common.services.backend.validation.ValidationUtils;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ValidationServiceImpl
implements ValidationService {
    @Inject
    private org.uberfire.ext.editor.commons.service.ValidationService validationService;
    @Inject
    private PackageNameValidator packageNameValidator;
    @Inject
    private ProjectNameValidator projectNameValidator;
    @Inject
    private JavaFileNameValidator javaFileNameValidator;

    public boolean isProjectNameValid(String projectName) {
        return this.projectNameValidator.isValid(projectName);
    }

    public boolean isPackageNameValid(String packageName) {
        return this.packageNameValidator.isValid(packageName);
    }

    public boolean isFileNameValid(Path path, String fileName) {
        return this.validationService.isFileNameValid(path, fileName);
    }

    public boolean isJavaFileNameValid(String fileName) {
        return this.javaFileNameValidator.isValid(fileName);
    }

    public boolean isFileNameValid(String fileName) {
        return this.validationService.isFileNameValid(fileName);
    }

    public Map<String, Boolean> evaluateJavaIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isJavaIdentifier(s));
            }
        }
        return result;
    }

    public Map<String, Boolean> evaluateMavenIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isArtifactIdentifier(s));
            }
        }
        return result;
    }

    public boolean isTimerIntervalValid(String timerInterval) {
        try {
            TimeIntervalParser.parse((String)timerInterval);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

