/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.whitelist;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.kie.workbench.common.services.backend.builder.NoBuilderFoundException;
import org.kie.workbench.common.services.shared.dependencies.DependencyService;

public class PackageNameSearchProvider {
    private DependencyService dependencyService;

    public PackageNameSearchProvider() {
    }

    @Inject
    public PackageNameSearchProvider(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public PackageNameSearch newTopLevelPackageNamesSearch(POM pom) {
        return new PackageNameSearch(pom);
    }

    public class PackageNameSearch {
        private final POM pom;
        private final Set<String> result = new HashSet<String>();

        private PackageNameSearch(POM pom) {
            this.pom = pom;
        }

        public Set<String> search() throws NoBuilderFoundException {
            this.loadPackageNames();
            return this.result;
        }

        private void loadPackageNames() throws NoBuilderFoundException {
            for (Dependency dependency : PackageNameSearchProvider.this.dependencyService.loadDependencies(this.pom.getGav())) {
                if (!this.isDependencyDefinedInThePOMXML(dependency)) continue;
                this.result.addAll(PackageNameSearchProvider.this.dependencyService.loadPackageNamesForDependency((GAV)dependency));
            }
        }

        private boolean isDependencyDefinedInThePOMXML(Dependency other) {
            for (Dependency dependency : this.pom.getDependencies()) {
                if (!this.areEqual(dependency.getArtifactId(), other.getArtifactId()) || !this.areEqual(dependency.getGroupId(), other.getGroupId())) continue;
                return true;
            }
            return false;
        }

        private boolean areEqual(String value, String other) {
            if (value == null || other == null) {
                return false;
            }
            return value.equals(other);
        }
    }
}

