/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.whitelist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.services.backend.file.AntPathMatcher;
import org.kie.workbench.common.services.backend.whitelist.WhiteList;
import org.uberfire.commons.validation.PortablePreconditions;

public class PackageNameWhiteListProvider {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private final Collection<String> packageNames;
    private final Set<String> patterns;

    public PackageNameWhiteListProvider(Collection<String> packageNames, Set<String> patterns) {
        this.packageNames = (Collection)PortablePreconditions.checkNotNull((String)"packageNames", packageNames);
        this.patterns = (Set)PortablePreconditions.checkNotNull((String)"patterns", patterns);
    }

    public WhiteList getFilteredPackageNames() {
        if (this.patterns.isEmpty()) {
            return new WhiteList(this.packageNames);
        }
        return this.filter(this.getPackageNamePaths());
    }

    private WhiteList filter(HashMap<String, String> packageNamePaths) {
        WhiteList whiteList = new WhiteList();
        for (String pattern : this.patterns) {
            for (Map.Entry<String, String> packageNamePath : packageNamePaths.entrySet()) {
                if (!ANT_PATH_MATCHER.match(pattern, packageNamePath.getValue())) continue;
                whiteList.add(packageNamePath.getKey());
            }
        }
        return whiteList;
    }

    private HashMap<String, String> getPackageNamePaths() {
        HashMap<String, String> packageNamePaths = new HashMap<String, String>();
        for (String packageName : this.packageNames) {
            packageNamePaths.put(packageName, packageName.replaceAll("\\.", "/"));
        }
        return packageNamePaths;
    }
}

