/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.whitelist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.builder.NoBuilderFoundException;
import org.kie.workbench.common.services.backend.whitelist.PackageNameSearchProvider;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListProvider;
import org.kie.workbench.common.services.backend.whitelist.WhiteList;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.whitelist.PackageNameWhiteListService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class PackageNameWhiteListServiceImpl
implements PackageNameWhiteListService {
    private static final Logger logger = LoggerFactory.getLogger(PackageNameWhiteListServiceImpl.class);
    private IOService ioService;
    private PackageNameSearchProvider packageNameSearchProvider;

    public PackageNameWhiteListServiceImpl() {
    }

    @Inject
    public PackageNameWhiteListServiceImpl(@Named(value="ioStrategy") IOService ioService, PackageNameSearchProvider packageNameSearchProvider) {
        this.ioService = ioService;
        this.packageNameSearchProvider = packageNameSearchProvider;
    }

    public WhiteList filterPackageNames(Project project, Collection<String> packageNames) {
        try {
            if (packageNames == null) {
                return new WhiteList();
            }
            if (project instanceof KieProject) {
                Set<String> packageNamesFromDirectDependencies = null;
                packageNamesFromDirectDependencies = this.packageNameSearchProvider.newTopLevelPackageNamesSearch(project.getPom()).search();
                Set<String> patterns = this.getDeclaredWhiteListPatterns(project);
                patterns.addAll(this.makePatterns(packageNamesFromDirectDependencies));
                return new PackageNameWhiteListProvider(packageNames, patterns).getFilteredPackageNames();
            }
            return new WhiteList(packageNames);
        }
        catch (NoBuilderFoundException e) {
            logger.info("Could not create white list for project: " + project.getProjectName());
            return new WhiteList();
        }
    }

    private Set<String> getDeclaredWhiteListPatterns(Project project) {
        String content = this.readPackageNameWhiteList((KieProject)project);
        if (this.isEmpty(content)) {
            return new HashSet<String>();
        }
        return this.makePatterns(this.parsePackageNamePatterns(content));
    }

    private Set<String> makePatterns(Collection<String> packageNames) {
        HashSet<String> patterns = new HashSet<String>();
        for (String packageName : packageNames) {
            patterns.add(packageName.replaceAll("\\.", "/"));
        }
        return patterns;
    }

    protected String readPackageNameWhiteList(KieProject project) {
        Path packageNamesWhiteListPath = Paths.convert((org.uberfire.backend.vfs.Path)project.getPackageNamesWhiteList());
        if (Files.exists((Path)packageNamesWhiteListPath, (LinkOption[])new LinkOption[0])) {
            return this.ioService.readAllString(packageNamesWhiteListPath);
        }
        return "";
    }

    private Set<String> parsePackageNamePatterns(String content) {
        try {
            return new HashSet<String>(IOUtils.readLines((Reader)new StringReader(content)));
        }
        catch (IOException ioe) {
            logger.warn("Unable to parse package names from '" + content + "'. Falling back to empty list.");
            return new HashSet<String>();
        }
    }

    private boolean isEmpty(String content) {
        return content == null || content.trim().isEmpty();
    }
}

