/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.Scheduler;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestBatcher<F extends RequestFactory, C extends RequestContext> {
    private C openContext;
    private AbstractRequestContext openContextImpl;
    private final F requestFactory;

    protected RequestBatcher(F requestFactory) {
        this.requestFactory = requestFactory;
    }

    public C get() {
        return this.get(null);
    }

    public C get(Receiver<Void> receiver) {
        if (this.openContext == null) {
            this.openContext = this.createContext(this.requestFactory);
            this.openContextImpl = (AbstractRequestContext)this.openContext;
            this.openContextImpl.setFireDisabled(true);
            this.getScheduler().scheduleFinally(new Scheduler.ScheduledCommand(){

                public void execute() {
                    assert (!RequestBatcher.this.openContextImpl.isLocked()) : "AbstractRequestContext.fire() should have been a no-op";
                    RequestBatcher.this.openContextImpl.setFireDisabled(false);
                    RequestBatcher.this.openContext.fire();
                    RequestBatcher.this.openContext = null;
                    RequestBatcher.this.openContextImpl = null;
                }
            });
        }
        if (receiver != null) {
            this.openContextImpl.fire(receiver);
        }
        return this.openContext;
    }

    public F getRequestFactory() {
        return this.requestFactory;
    }

    protected abstract C createContext(F var1);

    protected Scheduler getScheduler() {
        return Scheduler.get();
    }
}

