/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm.impl;

import com.google.gwt.dev.asm.Type;
import com.google.gwt.dev.asm.commons.Method;

public class OperationData {
    private String clientMethodDescriptor;
    private String domainMethodDescriptor;
    private String methodName;
    private String requestContextBinaryName;

    OperationData() {
    }

    public String getClientMethodDescriptor() {
        return this.clientMethodDescriptor;
    }

    public String getDomainMethodDescriptor() {
        return this.domainMethodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getRequestContext() {
        return this.requestContextBinaryName;
    }

    public String toString() {
        return this.getRequestContext() + "::" + this.getMethodName() + this.getDomainMethodDescriptor();
    }

    public static class Builder {
        OperationData d = new OperationData();

        public OperationData build() {
            Method noReturn;
            OperationData toReturn = this.d;
            this.d = null;
            if (toReturn.clientMethodDescriptor != null) {
                noReturn = new Method(toReturn.methodName, Type.VOID_TYPE, Type.getArgumentTypes(toReturn.clientMethodDescriptor));
                toReturn.clientMethodDescriptor = noReturn.getDescriptor();
            }
            if (toReturn.domainMethodDescriptor != null) {
                noReturn = new Method(toReturn.methodName, Type.VOID_TYPE, Type.getArgumentTypes(toReturn.domainMethodDescriptor));
                toReturn.domainMethodDescriptor = noReturn.getDescriptor();
            }
            return toReturn;
        }

        public Builder withClientMethodDescriptor(String clientMethodDescriptor) {
            this.d.clientMethodDescriptor = clientMethodDescriptor;
            return this;
        }

        public Builder withDomainMethodDescriptor(String domainMethodDescriptor) {
            this.d.domainMethodDescriptor = domainMethodDescriptor;
            return this;
        }

        public Builder withMethodName(String methodName) {
            this.d.methodName = methodName;
            return this;
        }

        public Builder withRequestContext(String requestContext) {
            this.d.requestContextBinaryName = requestContext;
            return this;
        }
    }
}

