/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.model.JarListPageRequest;
import org.guvnor.m2repo.model.JarListPageRow;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class M2RepoServiceImpl
implements M2RepoService,
ExtendedM2RepoService {
    @Inject
    private GuvnorM2Repository repository;

    @Override
    public void deployJar(InputStream is, GAV gav) {
        this.repository.deployArtifact(is, gav, true);
    }

    @Override
    public void deployJarInternal(InputStream is, GAV gav) {
        this.repository.deployArtifact(is, gav, false);
    }

    @Override
    public void deployPom(InputStream is, GAV gav) {
        this.repository.deployPom(is, gav);
    }

    public String getPomText(String path) {
        return GuvnorM2Repository.getPomText(path);
    }

    public GAV loadGAVFromJar(String path) {
        GAV gav = this.repository.loadGAVFromJar(path);
        return gav;
    }

    public PageResponse<JarListPageRow> listArtifacts(JarListPageRequest pageRequest) {
        List<File> files = this.repository.listFiles(pageRequest.getFilters(), pageRequest.getDataSourceName(), pageRequest.isAscending());
        PageResponse response = new PageResponse();
        ArrayList<JarListPageRow> jarPageRowList = new ArrayList<JarListPageRow>();
        int i = 0;
        for (File file : files) {
            if (i >= pageRequest.getStartRowIndex() + pageRequest.getPageSize()) break;
            if (i >= pageRequest.getStartRowIndex()) {
                JarListPageRow jarListPageRow = new JarListPageRow();
                jarListPageRow.setName(file.getName());
                jarListPageRow.setPath(this.getJarPath(file.getPath(), File.separator));
                jarListPageRow.setLastModified(new Date(file.lastModified()));
                jarPageRowList.add(jarListPageRow);
            }
            ++i;
        }
        response.setPageRowList(jarPageRowList);
        response.setStartRowIndex(pageRequest.getStartRowIndex());
        response.setTotalRowSize(files.size());
        response.setTotalRowSizeExact(true);
        return response;
    }

    String getJarPath(String path, String separator) {
        String jarPath = path.substring(GuvnorM2Repository.M2_REPO_DIR.length() + 1);
        jarPath = jarPath.replaceAll("\\" + separator, "/");
        return jarPath;
    }

    public String getRepositoryURL(String baseURL) {
        if (baseURL == null || baseURL.isEmpty()) {
            return this.repository.getRepositoryURL();
        }
        if (baseURL.endsWith("/")) {
            return baseURL + "maven2/";
        }
        return baseURL + "/maven2/";
    }
}

