/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.BeliefSystemType;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.RuleBaseConfiguration;
import org.drools.TimerJobFactoryType;
import org.drools.command.CommandService;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.StringUtils;
import org.drools.process.instance.WorkItemManagerFactory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KeepReferenceOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.conf.MultiValueKnowledgeSessionOption;
import org.drools.runtime.conf.QueryListenerOption;
import org.drools.runtime.conf.SingleValueKnowledgeSessionOption;
import org.drools.runtime.conf.TimerJobFactoryOption;
import org.drools.runtime.conf.WorkItemHandlerOption;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.time.TimerService;
import org.drools.time.impl.TimerJobFactoryManager;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.drools.util.CompositeClassLoader;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionConfiguration
implements KnowledgeSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 510L;
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private ClockType clockType;
    private BeliefSystemType beliefSystemType;
    private QueryListenerOption queryListener;
    private Map<String, WorkItemHandler> workItemHandlers;
    private WorkItemManagerFactory workItemManagerFactory;
    private CommandService commandService;
    private transient CompositeClassLoader classLoader;
    private transient TimerJobFactoryManager timerJobFactoryManager;
    private TimerJobFactoryType timerJobFactoryType;
    private static final SessionConfiguration defaultInstance = new SessionConfiguration();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
        out.writeObject((Object)this.clockType);
        out.writeObject(this.queryListener);
        out.writeObject((Object)this.timerJobFactoryType);
    }

    public static SessionConfiguration getDefaultInstance() {
        return defaultInstance;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
        this.clockType = (ClockType)((Object)in.readObject());
        this.queryListener = (QueryListenerOption)in.readObject();
        this.timerJobFactoryType = (TimerJobFactoryType)((Object)in.readObject());
    }

    public SessionConfiguration(Properties properties) {
        this.init(properties, null);
    }

    public SessionConfiguration() {
        this.init(null, null);
    }

    public SessionConfiguration(ClassLoader ... classLoader) {
        this.init(null, classLoader);
    }

    private void init(Properties properties, ClassLoader ... classLoader) {
        this.classLoader = ClassLoaderUtil.getClassLoader(classLoader, this.getClass(), false);
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("session.conf", this.classLoader);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.valueOf(this.chainedProperties.getProperty("drools.keepReference", "true")));
        this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(this.chainedProperties.getProperty("drools.beliefSystem", BeliefSystemType.SIMPLE.getId())));
        this.setClockType(ClockType.resolveClockType(this.chainedProperties.getProperty("drools.clockType", ClockType.REALTIME_CLOCK.getId())));
        this.setQueryListenerClass(this.chainedProperties.getProperty("drools.queryListener", QueryListenerOption.STANDARD.getAsString()));
        this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(this.chainedProperties.getProperty("drools.timerJobFactory", TimerJobFactoryType.DEFUALT.getId())));
    }

    public void addDefaultProperties(Properties properties) {
        Properties defaultProperties = new Properties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (this.chainedProperties.getProperty((String)prop.getKey(), null) != null) continue;
            defaultProperties.put(prop.getKey(), prop.getValue());
        }
        this.chainedProperties.addProperties(defaultProperties);
    }

    @Override
    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) || Boolean.parseBoolean(value));
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        } else if (name.equals("drools.timerJobFactory")) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(StringUtils.isEmpty(value) ? "default" : value));
        } else if (name.equals("drools.queryListener")) {
            this.setQueryListenerClass(StringUtils.isEmpty(value) ? QueryListenerOption.STANDARD.getAsString() : value);
        }
    }

    @Override
    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.keepReference);
        }
        if (name.equals("drools.clockType")) {
            return this.clockType.toExternalForm();
        }
        if (name.equals("drools.timerJobFactory")) {
            return this.timerJobFactoryType.toExternalForm();
        }
        if (name.equals("drools.queryListener")) {
            return this.queryListener.getAsString();
        }
        return null;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    public BeliefSystemType getBeliefSystemType() {
        return this.beliefSystemType;
    }

    public void setBeliefSystemType(BeliefSystemType beliefSystemType) {
        this.checkCanChange();
        this.beliefSystemType = beliefSystemType;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }

    public TimerJobFactoryManager getTimerJobFactoryManager() {
        if (this.timerJobFactoryManager == null) {
            this.timerJobFactoryManager = this.getTimerJobFactoryType().createInstance();
        }
        return this.timerJobFactoryManager;
    }

    public TimerJobFactoryType getTimerJobFactoryType() {
        return this.timerJobFactoryType;
    }

    private void setTimerJobFactoryType(TimerJobFactoryType timerJobFactoryType) {
        this.checkCanChange();
        this.timerJobFactoryType = timerJobFactoryType;
    }

    private void setQueryListenerClass(String property) {
        this.checkCanChange();
        this.queryListener = QueryListenerOption.determineQueryListenerClassOption(property);
    }

    private void setQueryListenerClass(QueryListenerOption option) {
        this.checkCanChange();
        this.queryListener = option;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(new HashMap<String, Object>());
        }
        return this.workItemHandlers;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> params) {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(params);
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers(Map<String, Object> params) {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation, params);
        }
    }

    private void loadWorkItemHandlers(String location, Map<String, Object> params) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)MVEL.eval((String)content, params);
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.workItemManagerFactory", "org.drools.process.instance.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public String getProcessInstanceManagerFactory() {
        return this.chainedProperties.getProperty("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
    }

    public String getSignalManagerFactory() {
        return this.chainedProperties.getProperty("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
    }

    public CommandService getCommandService(KnowledgeBase kbase, Environment environment) {
        if (this.commandService == null) {
            this.initCommandService(kbase, environment);
        }
        return this.commandService;
    }

    private void initCommandService(KnowledgeBase kbase, Environment environment) {
        String className = this.chainedProperties.getProperty("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.commandService = (CommandService)clazz.getConstructor(KnowledgeBase.class, KnowledgeSessionConfiguration.class, Environment.class).newInstance(kbase, this, environment);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }

    public TimerService newTimerService() {
        String className = this.chainedProperties.getProperty("drools.timerService", "org.drools.time.impl.JDKTimerService");
        if (className == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                return (TimerService)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate timer service '" + className + "'", e);
            }
        }
        throw new IllegalArgumentException("Timer service '" + className + "' not found");
    }

    @Override
    public <T extends SingleValueKnowledgeSessionOption> T getOption(Class<T> option) {
        if (ClockTypeOption.class.equals(option)) {
            return (T)ClockTypeOption.get(this.getClockType().toExternalForm());
        }
        if (KeepReferenceOption.class.equals(option)) {
            return (T)(this.keepReference ? KeepReferenceOption.YES : KeepReferenceOption.NO);
        }
        if (TimerJobFactoryOption.class.equals(option)) {
            return (T)TimerJobFactoryOption.get(this.getTimerJobFactoryType().toExternalForm());
        }
        if (QueryListenerOption.class.equals(option)) {
            return (T)this.queryListener;
        }
        return null;
    }

    @Override
    public <T extends MultiValueKnowledgeSessionOption> T getOption(Class<T> option, String key) {
        if (WorkItemHandlerOption.class.equals(option)) {
            return (T)WorkItemHandlerOption.get(key, this.getWorkItemHandlers().get(key));
        }
        return null;
    }

    @Override
    public <T extends KnowledgeSessionOption> void setOption(T option) {
        if (option instanceof ClockTypeOption) {
            this.setClockType(ClockType.resolveClockType(((ClockTypeOption)option).getClockType()));
        } else if (option instanceof TimerJobFactoryOption) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(((TimerJobFactoryOption)option).getTimerJobType()));
        } else if (option instanceof KeepReferenceOption) {
            this.setKeepReference(((KeepReferenceOption)option).isKeepReference());
        } else if (option instanceof WorkItemHandlerOption) {
            this.getWorkItemHandlers().put(((WorkItemHandlerOption)option).getName(), ((WorkItemHandlerOption)option).getHandler());
        } else if (option instanceof QueryListenerOption) {
            this.queryListener = (QueryListenerOption)option;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader.clone();
    }

    public void setClassLoader(CompositeClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public QueryListenerOption getQueryListenerOption() {
        return this.queryListener;
    }
}

