/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.BaseUploadServlet;
import org.uberfire.server.util.FileServletUtil;

public class FileUploadServlet
extends BaseUploadServlet {
    private static final String PARAM_PATH = "path";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_FILENAME = "fileName";
    private static final String RESPONSE_OK = "OK";
    private static final String RESPONSE_FAIL = "FAIL";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (request.getParameter(PARAM_PATH) != null) {
                String encodedPath = FileServletUtil.encodeFileNamePart(request.getParameter(PARAM_PATH));
                URI uri = new URI(encodedPath);
                FileItem fileItem = this.getFileItem(request);
                this.finalizeResponse(response, fileItem, uri);
            } else if (request.getParameter(PARAM_FOLDER) != null) {
                FileItem fileItem = this.getFileItem(request);
                String originalFileName = fileItem.getName();
                String providedFileName = request.getParameter(PARAM_FILENAME);
                String targetFileName = providedFileName.contains(".") ? providedFileName : providedFileName + this.getExtension(originalFileName);
                targetFileName = FileServletUtil.encodeFileName(targetFileName);
                URI uri = new URI(request.getParameter(PARAM_FOLDER) + "/" + targetFileName);
                this.finalizeResponse(response, fileItem, uri);
            }
        }
        catch (FileUploadException e) {
            this.logError(e);
            this.writeResponse(response, RESPONSE_FAIL);
        }
        catch (URISyntaxException e) {
            this.logError(e);
            this.writeResponse(response, RESPONSE_FAIL);
        }
    }

    private void finalizeResponse(HttpServletResponse response, FileItem fileItem, URI uri) throws IOException {
        if (!this.validateAccess(uri, response)) {
            return;
        }
        Path path = this.ioService.get(uri);
        this.writeFile(this.ioService, path, fileItem);
        this.writeResponse(response, RESPONSE_OK);
    }

    private String getExtension(String originalFileName) {
        if (originalFileName.contains(".")) {
            return "." + originalFileName.substring(originalFileName.lastIndexOf(".") + 1);
        }
        return "";
    }
}

