/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.kie.uberfire.social.activities.model.SocialUser;

public class SocialUserJsonDeserializer
implements JsonDeserializer<SocialUser> {
    public SocialUser deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement userName = jsonObject.get("userName");
        JsonElement realName = jsonObject.get("realName");
        JsonElement email = jsonObject.get("email");
        List<String> followers = this.deserializeUserNames(jsonObject.get("followers").getAsJsonArray());
        List<String> following = this.deserializeUserNames(jsonObject.get("following").getAsJsonArray());
        SocialUser socialUser = new SocialUser(userName.getAsString(), realName.getAsString(), email.getAsString(), followers, following);
        return socialUser;
    }

    private List<String> deserializeUserNames(JsonArray jsonFollowingEventsArray) {
        ArrayList<String> followers = new ArrayList<String>();
        for (int i = 0; i < jsonFollowingEventsArray.size(); ++i) {
            JsonElement jsonAuthor = jsonFollowingEventsArray.get(i);
            followers.add(jsonAuthor.getAsString());
        }
        return followers;
    }
}

