/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.CopyExpressionVisitor;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollection;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollectionIndex;
import org.drools.ide.common.client.modeldriven.brl.ExpressionField;
import org.drools.ide.common.client.modeldriven.brl.ExpressionGlobalVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionMethod;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionUnboundFact;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVisitor;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class ExpressionFormLine
implements IAction,
IPattern {
    private String binding = null;
    private LinkedList<ExpressionPart> parts = new LinkedList();

    public ExpressionFormLine() {
    }

    public ExpressionFormLine(ExpressionPart part) {
        this.appendPart(part);
    }

    public ExpressionFormLine(ExpressionFormLine other) {
        CopyExpressionVisitor copier = new CopyExpressionVisitor();
        if (other.getParts().size() == 0) {
            return;
        }
        for (ExpressionPart exp = copier.copy(other.getRootExpression()); exp != null; exp = exp.getNext()) {
            this.parts.add(exp);
        }
    }

    public String getText(boolean renderBindVariable) {
        return new ToStringVisitor().buildString(renderBindVariable ? this.getBinding() : null, this.getRootExpression());
    }

    public String getText() {
        return this.getText(false);
    }

    public void appendPart(ExpressionPart part) {
        if (!this.parts.isEmpty()) {
            this.parts.getLast().setNext(part);
        }
        this.parts.add(part);
    }

    public void removeLast() {
        ExpressionPart last;
        if (!this.parts.isEmpty() && (last = this.parts.removeLast()).getPrevious() != null) {
            last.getPrevious().setNext(null);
            last.setPrevious(null);
        }
    }

    private ExpressionPart getPreviousPart() {
        return this.parts.getLast();
    }

    public String getPreviousClassType() {
        ExpressionPart last = this.getPreviousPart();
        return last.getPrevious() == null ? null : last.getPrevious().getClassType();
    }

    public String getClassType() {
        return this.parts.getLast().getClassType();
    }

    public String getGenericType() {
        return this.parts.isEmpty() ? null : this.parts.getLast().getGenericType();
    }

    public String getFieldName() {
        return this.parts.isEmpty() ? null : this.parts.getLast().getName();
    }

    public String getPreviousGenericType() {
        ExpressionPart prev = this.getPreviousPart().getPrevious();
        return prev == null ? null : prev.getGenericType();
    }

    public String getParametricType() {
        return this.parts.getLast().getParametricType();
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public String getCurrentName() {
        return this.parts.getLast().getName();
    }

    public String getPreviousName() {
        ExpressionPart previousPart = this.getPreviousPart();
        return previousPart == null ? null : previousPart.getName();
    }

    public ExpressionPart getRootExpression() {
        return this.parts.isEmpty() ? null : this.parts.getFirst();
    }

    public boolean isBound() {
        return this.binding != null;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public List<ExpressionPart> getParts() {
        return this.parts;
    }

    private static class ToStringVisitor
    implements ExpressionVisitor {
        private StringBuilder str;
        private boolean first;

        private ToStringVisitor() {
        }

        public String buildString(String bindVariable, ExpressionPart exp) {
            if (exp == null) {
                return "";
            }
            this.str = new StringBuilder();
            this.first = true;
            exp.accept(this);
            return (bindVariable == null ? "" : bindVariable + ": ") + this.str.toString();
        }

        @Override
        public void visit(ExpressionPart part) {
            throw new IllegalStateException("can't generate text for: " + part.getClass().getName());
        }

        @Override
        public void visit(ExpressionField part) {
            if (!this.first) {
                this.str.append('.');
            }
            this.str.append(part.getName());
            this.moveNext(part);
        }

        @Override
        public void visit(ExpressionMethod part) {
            if (!this.first) {
                this.str.append('.');
            }
            this.str.append(part.getName()).append('(').append(this.paramsToString(part.getParams())).append(')');
            this.moveNext(part);
        }

        @Override
        public void visit(ExpressionVariable part) {
            this.str.append(part.getName());
            this.moveNext(part);
        }

        @Override
        public void visit(ExpressionUnboundFact part) {
            this.moveNext(part, false);
        }

        @Override
        public void visit(ExpressionGlobalVariable part) {
            this.str.append(part.getName());
            this.moveNext(part);
        }

        @Override
        public void visit(ExpressionCollection part) {
            if (!this.first) {
                this.str.append('.');
            }
            this.str.append(part.getName());
            this.moveNext(part);
        }

        @Override
        public void visit(ExpressionCollectionIndex part) {
            this.str.append('[').append(this.paramsToString(part.getParams())).append(']');
            this.moveNext(part);
        }

        @Override
        public void visit(ExpressionText part) {
            this.str.append(part.getName());
            this.moveNext(part);
        }

        private String paramsToString(Map<String, ExpressionFormLine> params) {
            if (params.isEmpty()) {
                return "";
            }
            ToStringVisitor stringVisitor = new ToStringVisitor();
            StringBuilder strParams = new StringBuilder();
            for (ExpressionFormLine param : params.values()) {
                strParams.append(", ").append(stringVisitor.buildString(param.getBinding(), param.getRootExpression()));
            }
            return strParams.substring(2);
        }

        private void moveNext(ExpressionPart exp) {
            this.moveNext(exp, true);
        }

        private void moveNext(ExpressionPart exp, boolean resetFirst) {
            if (exp.getNext() != null) {
                if (resetFirst) {
                    this.first = false;
                }
                exp.getNext().accept(this);
            }
        }
    }
}

