/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionManager;
import org.picketlink.idm.spi.model.IdentityObject;

@Named
@ConversationScoped
public class PermissionSearch
implements Serializable {
    private static final long serialVersionUID = 2802038930768758665L;
    private Map<IdentityObject, List<Permission>> groupedPermissions = new HashMap<IdentityObject, List<Permission>>();
    List<IdentityObject> recipients;
    Principal selectedRecipient;
    @Inject
    PermissionManager permissionManager;
    @Inject
    Conversation conversation;
    private Object target;

    public void search(Object target) {
        this.conversation.begin();
        this.target = target;
    }

    public void refresh() {
        List<Permission> permissions = this.permissionManager.listPermissions(this.target);
        this.groupedPermissions.clear();
        for (Permission permission : permissions) {
            List<Object> recipientPermissions = null;
            if (!this.groupedPermissions.containsKey(permission.getIdentity())) {
                recipientPermissions = new ArrayList();
                this.groupedPermissions.put(permission.getIdentity(), recipientPermissions);
            } else {
                recipientPermissions = this.groupedPermissions.get(permission.getIdentity());
            }
            recipientPermissions.add(permission);
        }
        this.recipients = new ArrayList<IdentityObject>(this.groupedPermissions.keySet());
    }

    public String getActions(Principal recipient) {
        StringBuilder sb = new StringBuilder();
        for (Permission permission : this.groupedPermissions.get(recipient)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(permission.getPermission());
        }
        return sb.toString();
    }

    public Object getTarget() {
        return this.target;
    }

    public void revokeSelected() {
        this.permissionManager.revokePermissions(this.getSelectedPermissions());
        this.refresh();
    }

    public Principal getSelectedRecipient() {
        return this.selectedRecipient;
    }

    public List<Permission> getSelectedPermissions() {
        return this.groupedPermissions.get(this.selectedRecipient);
    }
}

