/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.asseteditor.DefaultRuleContentWidget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModels;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModelsEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.shared.api.PortableObject;

public class FactModelsWidget
extends Composite
implements SaveEventListener,
EditorWidget {
    private final Asset asset;
    private final ClientFactory clientFactory;
    private final List<FactMetaModel> superTypeFactModels = new ArrayList<FactMetaModel>();
    private final ModelNameHelper modelNameHelper = new ModelNameHelper();
    private final SimplePanel editorContainer = new SimplePanel();

    public FactModelsWidget(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this.asset = asset;
        this.clientFactory = clientFactory;
        if (this.isContentPlainText()) {
            this.initWidget(this.getPlainTextEditor());
        } else {
            this.initWidget((Widget)this.editorContainer);
            this.initFactModelsEditor();
        }
        this.setWidth("100%");
        this.setStyleName("model-builder-Background");
    }

    private boolean isContentPlainText() {
        return this.asset.getContent() instanceof RuleContentText;
    }

    private Widget getPlainTextEditor() {
        return new DefaultRuleContentWidget(this.asset);
    }

    private void initFactModelsEditor() {
        if (this.asset.getContent() == null) {
            this.asset.setContent((PortableObject)new FactModels());
        }
        this.populateSuperTypesFactModels();
    }

    private void populateSuperTypesFactModels() {
        String containingModuleUUID = this.asset.getMetaData().getModuleUUID();
        List<String> formats = Arrays.asList("model.drl");
        AssetPageRequest request = new AssetPageRequest(containingModuleUUID, formats, null);
        this.clientFactory.getAssetService().findAssetPage(request, this.makeLoadAssetsCallback());
    }

    private GenericCallback<PageResponse<AssetPageRow>> makeLoadAssetsCallback() {
        return new GenericCallback<PageResponse<AssetPageRow>>(){

            public void onSuccess(PageResponse<AssetPageRow> result) {
                this.loadFactModelAssets(result.getPageRowList());
            }

            private void loadFactModelAssets(List<AssetPageRow> assets) {
                FactModelsWidget.this.loadFacts(FactModelsWidget.this.asset);
                FactModelsSemaphore s = new FactModelsSemaphore(assets.size() - 1);
                if (s.areAllFactModelsProcessed()) {
                    FactModelsWidget.this.addEditorToContainer();
                } else {
                    for (AssetPageRow otherAsset : assets) {
                        if (otherAsset.getUuid().equals(FactModelsWidget.this.asset.getUuid())) continue;
                        FactModelsWidget.this.clientFactory.getAssetService().loadRuleAsset(otherAsset.getUuid(), (AsyncCallback)FactModelsWidget.this.makeLoadFactModelsCallback(s));
                    }
                }
            }
        };
    }

    private GenericCallback<Asset> makeLoadFactModelsCallback(final FactModelsSemaphore s) {
        return new GenericCallback<Asset>(){

            public void onSuccess(Asset otherAsset) {
                FactModelsWidget.this.loadFacts(otherAsset);
                s.recordFactModelProcessed();
                if (s.areAllFactModelsProcessed()) {
                    FactModelsWidget.this.addEditorToContainer();
                }
            }
        };
    }

    private void addEditorToContainer() {
        FactModelsEditor editor = new FactModelsEditor(((FactModels)this.asset.getContent()).models, this.superTypeFactModels, this.modelNameHelper);
        this.editorContainer.setWidget((Widget)editor);
    }

    private void loadFacts(Asset asset) {
        if (asset.getContent() == null) {
            asset.setContent((PortableObject)new FactModels());
        }
        FactModels factModels = (FactModels)asset.getContent();
        for (FactMetaModel factMetaModel : factModels.models) {
            this.superTypeFactModels.add(factMetaModel);
            this.modelNameHelper.getTypeDescriptions().put(factMetaModel.getName(), factMetaModel.getName());
        }
    }

    public void onAfterSave() {
    }

    public void onSave(SaveCommand saveCommand) {
        saveCommand.save();
    }

    private static class FactModelsSemaphore {
        int numberOfFactModels = 0;

        FactModelsSemaphore(int numberOfFactModels) {
            this.numberOfFactModels = numberOfFactModels;
        }

        synchronized void recordFactModelProcessed() {
            --this.numberOfFactModels;
        }

        synchronized boolean areAllFactModelsProcessed() {
            return this.numberOfFactModels == 0;
        }
    }
}

