/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.BoundTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CustomFormPopUp;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionTypeChangeEvent;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.TemplateKeyTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.events.TemplateVariablesChangedEvent;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.PopupDatePicker;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.drools.WorkingSetManager;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.factconstraints.customform.CustomFormConfiguration;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.HasOperator;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class ConstraintValueEditor
extends DirtyableComposite {
    private String factType;
    private CompositeFieldConstraint constraintList;
    private String fieldName;
    private String fieldType;
    private final SuggestionCompletionEngine sce;
    private final BaseSingleFieldConstraint constraint;
    private final Panel panel;
    private final RuleModel model;
    private final RuleModeller modeller;
    private final EventBus eventBus;
    private DropDownData dropDownData;
    private boolean readOnly;
    private Command onValueChangeCommand;
    private boolean isDropDownDataEnum;
    private Widget constraintWidget = null;

    public ConstraintValueEditor(BaseSingleFieldConstraint con, CompositeFieldConstraint constraintList, RuleModeller modeller, EventBus eventBus, boolean readOnly) {
        this.constraint = con;
        this.constraintList = constraintList;
        this.sce = modeller.getSuggestionCompletions();
        this.model = modeller.getModel();
        this.modeller = modeller;
        this.eventBus = eventBus;
        this.readOnly = readOnly;
        this.panel = new SimplePanel();
        if (con instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)con;
            this.factType = sfexp.getExpressionLeftSide().getPreviousGenericType();
            if (this.factType == null) {
                this.factType = sfexp.getExpressionLeftSide().getGenericType();
            }
            this.fieldName = sfexp.getExpressionLeftSide().getFieldName();
            this.fieldType = sfexp.getExpressionLeftSide().getGenericType();
        } else if (con instanceof ConnectiveConstraint) {
            ConnectiveConstraint cc = (ConnectiveConstraint)con;
            this.factType = cc.getFactType();
            this.fieldName = cc.getFieldName();
            this.fieldType = cc.getFieldType();
        } else if (con instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            this.factType = sfc.getFactType();
            this.fieldName = sfc.getFieldName();
            this.fieldType = this.sce.getFieldType(this.factType, this.fieldName);
        }
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    public BaseSingleFieldConstraint getConstraint() {
        return this.constraint;
    }

    private void refreshEditor() {
        this.panel.clear();
        this.constraintWidget = null;
        if (this.constraint instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)this.constraint;
            this.factType = sfexp.getExpressionLeftSide().getPreviousGenericType();
            if (this.factType == null) {
                this.factType = sfexp.getExpressionLeftSide().getGenericType();
            }
            this.fieldName = sfexp.getExpressionLeftSide().getFieldName();
            this.fieldType = sfexp.getExpressionLeftSide().getGenericType();
        }
        this.getDropDownData();
        if (this.constraint.getConstraintValueType() == 0) {
            ImageButton clickme = new ImageButton(GuvnorImages.INSTANCE.Edit(), DroolsGuvnorImages.INSTANCE.EditDisabled(), ConstantsCore.INSTANCE.Edit(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ConstraintValueEditor.this.showTypeChoice((Widget)event.getSource(), ConstraintValueEditor.this.constraint);
                }
            });
            clickme.setEnabled(!this.readOnly);
            this.constraintWidget = clickme;
        } else {
            switch (this.constraint.getConstraintValueType()) {
                case 1: 
                case 4: {
                    this.constraintWidget = this.wrap(this.literalEditor());
                    break;
                }
                case 3: {
                    this.constraintWidget = this.wrap(this.returnValueEditor());
                    break;
                }
                case 6: {
                    this.constraintWidget = this.wrap(this.expressionEditor());
                    break;
                }
                case 2: {
                    this.constraintWidget = this.wrap(this.variableEditor());
                    break;
                }
                case 7: {
                    this.constraintWidget = this.wrap(this.templateKeyEditor());
                    break;
                }
            }
        }
        this.panel.add(this.constraintWidget);
    }

    private Widget wrap(Widget w) {
        if (this.readOnly) {
            return w;
        }
        HorizontalPanel wrapper = new HorizontalPanel();
        Image clear = DroolsGuvnorImages.INSTANCE.DeleteItemSmall();
        clear.setTitle(Constants.INSTANCE.RemoveConstraintValueDefinition());
        clear.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)Constants.INSTANCE.RemoveConstraintValueDefinitionQuestion())) {
                    ConstraintValueEditor.this.constraint.setConstraintValueType(0);
                    ConstraintValueEditor.this.constraint.setValue(null);
                    ConstraintValueEditor.this.constraint.clearParameters();
                    ConstraintValueEditor.this.constraint.setExpressionValue(new ExpressionFormLine());
                    ConstraintValueEditor.this.doTypeChosen();
                }
            }
        });
        wrapper.add(w);
        if (!this.readOnly) {
            wrapper.add((Widget)clear);
            wrapper.setCellVerticalAlignment((Widget)clear, HasVerticalAlignment.ALIGN_MIDDLE);
        }
        return wrapper;
    }

    private String assertValue() {
        if (this.constraint.getValue() == null) {
            return "";
        }
        return this.constraint.getValue();
    }

    private Widget literalEditor() {
        String operator;
        if (this.constraint instanceof SingleFieldConstraint) {
            SingleFieldConstraint con = (SingleFieldConstraint)this.constraint;
            CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(this.modeller.getAsset().getMetaData().getModuleName(), this.factType, this.fieldName);
            if (customFormConfiguration != null) {
                Button btnCustom = new Button(con.getValue(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ConstraintValueEditor.this.showTypeChoice((Widget)event.getSource(), ConstraintValueEditor.this.constraint);
                    }
                });
                btnCustom.setEnabled(!this.readOnly);
                return btnCustom;
            }
        }
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        if (this.dropDownData != null) {
            operator = this.constraint.getOperator();
            boolean multipleSelect = SuggestionCompletionEngine.operatorRequiresList((String)operator);
            EnumDropDown enumDropDown = new EnumDropDown(this.constraint.getValue(), new DropDownValueChanged(){

                public void valueChanged(String newText, String newValue) {
                    if (!newValue.equals(ConstraintValueEditor.this.constraint.getValue())) {
                        ConstraintValueEditor.this.constraint.setValue(newValue);
                        ConstraintValueEditor.this.executeOnValueChangeCommand();
                        ConstraintValueEditor.this.makeDirty();
                    }
                }
            }, this.dropDownData, multipleSelect);
            return enumDropDown;
        }
        operator = null;
        if (this.constraint instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)this.constraint;
            operator = sfc.getOperator();
        }
        if (SuggestionCompletionEngine.operatorRequiresList((String)operator)) {
            final TextBox box = TextBoxFactory.getTextBox("String");
            box.setStyleName("constraint-value-Editor");
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConstraintValueEditor.this.constraint.setValue(box.getText());
                    ConstraintValueEditor.this.executeOnValueChangeCommand();
                    ConstraintValueEditor.this.makeDirty();
                }
            });
            box.setText(this.assertValue());
            this.attachDisplayLengthHandler(box);
            return box;
        }
        boolean isCEPOperator = false;
        if (this.constraint instanceof HasOperator) {
            isCEPOperator = SuggestionCompletionEngine.isCEPOperator((String)this.constraint.getOperator());
        }
        if ("Date".equals(this.fieldType) || "this".equals(this.fieldName) && isCEPOperator) {
            if (this.readOnly) {
                return new SmallLabel(this.constraint.getValue());
            }
            PopupDatePicker dp = new PopupDatePicker(false);
            dp.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    ConstraintValueEditor.this.constraint.setValue(PopupDatePicker.convertToString(event));
                    ConstraintValueEditor.this.executeOnValueChangeCommand();
                }
            });
            dp.setValue(this.assertValue());
            return dp;
        }
        final TextBox box = TextBoxFactory.getTextBox(this.fieldType);
        box.setStyleName("constraint-value-Editor");
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConstraintValueEditor.this.constraint.setValue(box.getText());
                ConstraintValueEditor.this.executeOnValueChangeCommand();
                ConstraintValueEditor.this.makeDirty();
            }
        });
        box.setText(this.assertValue());
        this.attachDisplayLengthHandler(box);
        return box;
    }

    private Widget variableEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.constraint.getValue());
        }
        final ListBox box = new ListBox();
        box.addItem(Constants.INSTANCE.Choose());
        List bindingsInScope = this.model.getBoundVariablesInScope(this.constraint);
        List<String> applicableBindingsInScope = this.getApplicableBindingsInScope(bindingsInScope);
        for (String var : applicableBindingsInScope) {
            box.addItem(var);
            if (this.constraint.getValue() == null || !this.constraint.getValue().equals(var)) continue;
            box.setSelectedIndex(box.getItemCount() - 1);
        }
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConstraintValueEditor.this.executeOnValueChangeCommand();
                int selectedIndex = box.getSelectedIndex();
                if (selectedIndex > 0) {
                    ConstraintValueEditor.this.constraint.setValue(box.getItemText(selectedIndex));
                } else {
                    ConstraintValueEditor.this.constraint.setValue(null);
                }
            }
        });
        return box;
    }

    private Widget returnValueEditor() {
        BoundTextBox box = new BoundTextBox(this.constraint);
        if (this.readOnly) {
            return new SmallLabel(box.getText());
        }
        String msg = Constants.INSTANCE.FormulaEvaluateToAValue();
        Image img = new Image(DroolsGuvnorImageResources.INSTANCE.functionAssets());
        img.setTitle(msg);
        box.setTitle(msg);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConstraintValueEditor.this.executeOnValueChangeCommand();
            }
        });
        Panel ed = this.widgets((Widget)img, (Widget)box);
        return ed;
    }

    private Widget expressionEditor() {
        ExpressionBuilder builder = null;
        builder = new ExpressionBuilder(this.modeller, this.eventBus, this.constraint.getExpressionValue(), this.readOnly);
        builder.addExpressionTypeChangeHandler(new ExpressionTypeChangeHandler(){

            @Override
            public void onExpressionTypeChanged(ExpressionTypeChangeEvent event) {
                System.out.println("type changed: " + event.getOldType() + " -> " + event.getNewType());
            }
        });
        builder.addOnModifiedCommand(new Command(){

            public void execute() {
                ConstraintValueEditor.this.executeOnValueChangeCommand();
            }
        });
        Panel ed = this.widgets((Widget)new HTML("&nbsp;"), (Widget)builder);
        return ed;
    }

    private Widget templateKeyEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.assertValue());
        }
        TemplateKeyTextBox box = new TemplateKeyTextBox();
        box.setStyleName("constraint-value-Editor");
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ConstraintValueEditor.this.constraint.setValue((String)event.getValue());
                ConstraintValueEditor.this.executeOnValueChangeCommand();
            }
        });
        box.setValue(this.assertValue(), true);
        this.attachDisplayLengthHandler((TextBox)box);
        return box;
    }

    private void attachDisplayLengthHandler(final TextBox box) {
        int length = box.getText().length();
        box.setVisibleLength(length > 0 ? length : 1);
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                int length = box.getText().length();
                box.setVisibleLength(length > 0 ? length : 1);
            }
        });
    }

    private void showTypeChoice(Widget w, final BaseSingleFieldConstraint con) {
        List<String> applicableBindingsInScope;
        List bindingsInScope;
        ConnectiveConstraint cc;
        String fieldName;
        boolean showExpressionSelector;
        CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(this.modeller.getAsset().getMetaData().getModuleName(), this.factType, this.fieldName);
        if (customFormConfiguration != null) {
            if (!(con instanceof SingleFieldConstraint)) {
                Window.alert((String)"Unexpected constraint type!");
                return;
            }
            final CustomFormPopUp customFormPopUp = new CustomFormPopUp(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.FieldValue(), customFormConfiguration);
            final SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            customFormPopUp.addOkButtonHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    sfc.setConstraintValueType(1);
                    sfc.setId(customFormPopUp.getFormId());
                    sfc.setValue(customFormPopUp.getFormValue());
                    ConstraintValueEditor.this.doTypeChosen(customFormPopUp);
                }
            });
            customFormPopUp.show(sfc.getId(), sfc.getValue());
            return;
        }
        final FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.FieldValue());
        Button lit = new Button(Constants.INSTANCE.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                con.setConstraintValueType(ConstraintValueEditor.this.isDropDownDataEnum && ConstraintValueEditor.this.dropDownData != null ? 4 : 1);
                ConstraintValueEditor.this.doTypeChosen(form);
            }
        });
        boolean showLiteralSelector = true;
        boolean showFormulaSelector = !SuggestionCompletionEngine.operatorRequiresList((String)con.getOperator());
        boolean showVariableSelector = !SuggestionCompletionEngine.operatorRequiresList((String)con.getOperator());
        boolean bl = showExpressionSelector = !SuggestionCompletionEngine.operatorRequiresList((String)con.getOperator());
        if (con instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            fieldName = sfc.getFieldName();
            if (fieldName.equals("this")) {
                showLiteralSelector = SuggestionCompletionEngine.isCEPOperator((String)sfc.getOperator());
                showFormulaSelector = showFormulaSelector && showLiteralSelector;
            }
        } else if (con instanceof ConnectiveConstraint && (fieldName = (cc = (ConnectiveConstraint)con).getFieldName()).equals("this")) {
            showLiteralSelector = SuggestionCompletionEngine.isCEPOperator((String)cc.getOperator());
            boolean bl2 = showFormulaSelector = showFormulaSelector && showLiteralSelector;
        }
        if (showLiteralSelector) {
            form.addAttribute(Constants.INSTANCE.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(Constants.INSTANCE.LiteralValue(), Constants.INSTANCE.LiteralValTip())));
        }
        if (this.modeller.isTemplate()) {
            String templateKeyLabel = Constants.INSTANCE.TemplateKey();
            Button templateKeyButton = new Button(templateKeyLabel);
            templateKeyButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(7);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(templateKeyLabel + ":", (Widget)this.widgets((Widget)templateKeyButton, (Widget)new InfoPopup(templateKeyLabel, Constants.INSTANCE.LiteralValTip())));
        }
        if (showVariableSelector || showFormulaSelector || showExpressionSelector) {
            form.addRow((Widget)new HTML("<hr/>"));
            form.addRow((Widget)new SmallLabel(Constants.INSTANCE.AdvancedOptions()));
        }
        if (showVariableSelector && ((bindingsInScope = this.model.getBoundVariablesInScope(this.constraint)).size() > 0 || "Collection".equals(this.fieldType)) && (applicableBindingsInScope = this.getApplicableBindingsInScope(bindingsInScope)).size() > 0) {
            Button variable = new Button(Constants.INSTANCE.BoundVariable());
            variable.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(2);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(Constants.INSTANCE.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(Constants.INSTANCE.ABoundVariable(), Constants.INSTANCE.BoundVariableTip())));
        }
        if (showFormulaSelector) {
            Button formula = new Button(Constants.INSTANCE.NewFormula());
            formula.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(3);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(Constants.INSTANCE.AFormula() + ":", (Widget)this.widgets((Widget)formula, (Widget)new InfoPopup(Constants.INSTANCE.AFormula(), Constants.INSTANCE.FormulaExpressionTip())));
        }
        if (showExpressionSelector) {
            Button expression = new Button(Constants.INSTANCE.ExpressionEditor());
            expression.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    con.setConstraintValueType(6);
                    ConstraintValueEditor.this.doTypeChosen(form);
                }
            });
            form.addAttribute(Constants.INSTANCE.ExpressionEditor() + ":", (Widget)this.widgets((Widget)expression, (Widget)new InfoPopup(Constants.INSTANCE.ExpressionEditor(), Constants.INSTANCE.ExpressionEditor())));
        }
        form.show();
    }

    private void doTypeChosen() {
        this.executeOnValueChangeCommand();
        this.executeOnTemplateVariablesChange();
        this.refreshEditor();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.doTypeChosen();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    private List<String> getApplicableBindingsInScope(List<String> bindingsInScope) {
        ArrayList<String> applicableBindingsInScope = new ArrayList<String>();
        for (String v : bindingsInScope) {
            FieldConstraint fc;
            FactPattern fp = this.model.getLHSBoundFact(v);
            if (fp != null && this.isLHSFactTypeEquivalent(v)) {
                applicableBindingsInScope.add(v);
            }
            if ((fc = this.model.getLHSBoundField(v)) == null || !this.isLHSFieldTypeEquivalent(v)) continue;
            applicableBindingsInScope.add(v);
        }
        return applicableBindingsInScope;
    }

    private boolean isLHSFactTypeEquivalent(String boundVariable) {
        String boundFactType = this.model.getLHSBoundFact(boundVariable).getFactType();
        String boundFieldType = this.model.getLHSBindingType(boundVariable);
        if (boundFactType.equals("Comparable")) {
            if (!this.fieldType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.sce.getEnumValues(boundFactType, this.fieldName);
            return this.isEnumEquivalent(dd);
        }
        return this.isBoundVariableApplicable(boundFactType, boundFieldType);
    }

    private boolean isLHSFieldTypeEquivalent(String boundVariable) {
        String boundFieldType = this.model.getLHSBindingType(boundVariable);
        if (boundFieldType.equals("Comparable")) {
            if (!this.fieldType.equals("Comparable")) {
                return false;
            }
            FieldConstraint fc = this.model.getLHSBoundField(boundVariable);
            if (fc instanceof SingleFieldConstraint) {
                String fieldName = ((SingleFieldConstraint)fc).getFieldName();
                String parentFactTypeForBinding = this.model.getLHSParentFactPatternForBinding(boundVariable).getFactType();
                String[] dd = this.sce.getEnumValues(parentFactTypeForBinding, fieldName);
                return this.isEnumEquivalent(dd);
            }
            return false;
        }
        return this.isBoundVariableApplicable(boundFieldType);
    }

    private boolean isEnumEquivalent(String[] values) {
        if (values == null && this.dropDownData.fixedList != null) {
            return false;
        }
        if (values != null && this.dropDownData.fixedList == null) {
            return false;
        }
        if (values.length != this.dropDownData.fixedList.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(this.dropDownData.fixedList[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isBoundVariableApplicable(String boundFactType, String boundFieldType) {
        if (boundFactType != null && boundFactType.equals(this.fieldType)) {
            return true;
        }
        if (this.fieldName.equals("this") && boundFactType != null && boundFactType.equals(this.factType)) {
            return true;
        }
        String factCollectionType = this.sce.getParametricFieldType(this.factType, this.fieldName);
        if (boundFactType != null && factCollectionType != null && boundFactType.equals(factCollectionType)) {
            return true;
        }
        return this.isBoundVariableApplicable(boundFieldType);
    }

    private boolean isBoundVariableApplicable(String boundFieldType) {
        BaseSingleFieldConstraint hop;
        if (boundFieldType != null && boundFieldType.equals(this.fieldType)) {
            return true;
        }
        if (this.fieldName.equals("this") && boundFieldType != null && boundFieldType.equals(this.factType)) {
            return true;
        }
        if (this.fieldName.equals("this") && this.sce.isFactTypeAnEvent(boundFieldType) && this.constraint instanceof HasOperator && SuggestionCompletionEngine.isCEPOperator((String)(hop = this.constraint).getOperator())) {
            return true;
        }
        if (this.fieldName.equals("this") && boundFieldType.equals("Date") && this.constraint instanceof HasOperator && SuggestionCompletionEngine.isCEPOperator((String)(hop = this.constraint).getOperator())) {
            return true;
        }
        if (this.fieldType.equals("Date") && this.sce.isFactTypeAnEvent(boundFieldType) && this.constraint instanceof HasOperator && SuggestionCompletionEngine.isCEPOperator((String)(hop = this.constraint).getOperator())) {
            return true;
        }
        String factCollectionType = this.sce.getParametricFieldType(this.factType, this.fieldName);
        return factCollectionType != null && factCollectionType.equals(boundFieldType);
    }

    private DropDownData getDropDownData() {
        if ("Boolean".equals(this.fieldType)) {
            this.isDropDownDataEnum = false;
            this.dropDownData = DropDownData.create((String[])new String[]{"true", "false"});
        } else {
            this.isDropDownDataEnum = true;
            this.dropDownData = this.sce.getEnums(this.factType, this.constraintList, this.fieldName);
        }
        return this.dropDownData;
    }

    public void refreshDropDownData() {
        if (this.dropDownData == null) {
            return;
        }
        if (this.constraintWidget instanceof HorizontalPanel) {
            HorizontalPanel hp = (HorizontalPanel)this.constraintWidget;
            for (int iChildIndex = 0; iChildIndex < hp.getWidgetCount(); ++iChildIndex) {
                Widget w = hp.getWidget(iChildIndex);
                if (!(w instanceof EnumDropDown)) continue;
                EnumDropDown edd = (EnumDropDown)w;
                edd.setDropDownData(this.constraint.getValue(), this.getDropDownData());
            }
        }
    }

    private void executeOnTemplateVariablesChange() {
        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(this.model);
        this.eventBus.fireEventFromSource((GwtEvent)tvce, (Object)this.model);
    }
}

