/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.generators;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.server.maven.cache.GuvnorArtifactCacheSupport;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceWarGenerator {
    private static final Logger log = LoggerFactory.getLogger(ServiceWarGenerator.class);
    private static final Map<String, CompiledTemplate> templateMap = new HashMap<String, CompiledTemplate>(5){
        {
            this.put("WEB-INF/classes/beans.xml", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/beans.xml.template")));
            this.put("WEB-INF/classes/camel-server.xml", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/camel-server.xml.template")));
            this.put("WEB-INF/classes/knowledge-services.xml", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/knowledge-services.xml.template")));
            this.put("WEB-INF/web.xml", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/web.xml.template")));
        }
    };
    private static final TemplateRegistry templateRegistry = new SimpleTemplateRegistry(){
        {
            this.addNamedTemplate("ksession.uri", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/ksession.uri.template")));
            this.addNamedTemplate("kagent.def", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/kagent.def.template")));
            this.addNamedTemplate("ksession.def", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/ksession.def.template")));
            this.addNamedTemplate("resource.def", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/resource.def.template")));
            this.addNamedTemplate("kbase-config.def", TemplateCompiler.compileTemplate((String)ServiceWarGenerator.getResourceContent("servicewar/kbase-config.def.template")));
        }
    };

    private ServiceWarGenerator() {
    }

    public static void buildWar(ServiceConfig config, RulesRepository repository, OutputStream out) {
        HashMap<String, File> models = new HashMap<String, File>();
        for (AssetReference model : config.getModels()) {
            try {
                AssetItem asset = repository.loadAssetByUUID(model.getUrl());
                File temp = File.createTempFile(asset.getBinaryContentAttachmentFileName(), ".jar");
                temp.deleteOnExit();
                FileOutputStream tempStream = new FileOutputStream(temp);
                IOUtils.copy((InputStream)asset.getBinaryContentAttachment(), (OutputStream)tempStream);
                tempStream.flush();
                tempStream.close();
                models.put(asset.getBinaryContentAttachmentFileName(), temp);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        ServiceWarGenerator.buildWar(config, models, out);
    }

    public static void buildWar(final ServiceConfig config, Map<String, File> models, OutputStream out) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)out);
        HashMap<String, Object> data = new HashMap<String, Object>(){
            {
                this.put("serviceConfig", config);
            }
        };
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"drools-service.war");
        for (Map.Entry<String, CompiledTemplate> entry : templateMap.entrySet()) {
            String content = (String)TemplateRuntime.execute((CompiledTemplate)entry.getValue(), null, (Map)data, (TemplateRegistry)templateRegistry);
            archive.add((Asset)new StringAsset(content), entry.getKey());
        }
        for (File file : GuvnorArtifactCacheSupport.resolveArtifacts(config.getExcludedArtifacts())) {
            archive.addAsLibraries(new File[]{file});
        }
        if (models != null && models.size() > 0) {
            for (Map.Entry<String, Object> entry : models.entrySet()) {
                archive.addAsLibrary((File)entry.getValue(), entry.getKey());
            }
        }
        try {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(out);
            out.flush();
            out.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getResourceContent(String fileName) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            BufferedInputStream inContent = new BufferedInputStream(ServiceWarGenerator.class.getClassLoader().getResourceAsStream(fileName));
            IOUtils.copy((InputStream)inContent, (OutputStream)outContent);
            return outContent.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error " + fileName, ex);
        }
    }
}

