/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.net.URL;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatListener
extends Listener {
    private static final Logger log = LoggerFactory.getLogger(TomcatListener.class);

    @Override
    protected URLScanner createUrlScanner(ClassLoader classLoader, ServletContext context) {
        return new TomcatScanner(classLoader);
    }

    protected static void recurse(DirContext context, Set<String> classes, Set<URL> urls, String prefix) throws Exception {
        if (prefix.length() > 0) {
            prefix = prefix + ".";
        }
        NamingEnumeration<Binding> ne = context.listBindings("");
        while (ne.hasMoreElements()) {
            Binding next = (Binding)ne.nextElement();
            String name = prefix + next.getName();
            if (name.endsWith(".class")) {
                classes.add(name.substring(0, name.length() - 6));
                continue;
            }
            Object nextObject = next.getObject();
            if (!(nextObject instanceof DirContext)) continue;
            TomcatListener.recurse((DirContext)nextObject, classes, urls, name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TomcatScanner
    extends URLScanner {
        private TomcatScanner(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        protected void handleURL(URL url, Set<String> classes, Set<URL> urls) {
            try {
                Object content = url.getContent();
                if (content instanceof DirContext) {
                    TomcatListener.recurse((DirContext)content, classes, urls, "");
                } else {
                    log.warn("Cannot scan URL, content not javax.naming.Context instance.");
                }
            }
            catch (Exception e) {
                log.error("Cannot scan URL: " + url, (Throwable)e);
            }
        }
    }
}

