/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.Date;
import org.drools.workbench.jcr2vfsmigration.xml.ExportXmlUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.PlainTextAsset;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlainTextAssetFormat
extends XmlAssetFormat {
    private static final String TEXT_CONTENT = "textContent";

    protected String doFormat(PlainTextAsset plainTextAsset) {
        StringBuilder sb = new StringBuilder("<").append(TEXT_CONTENT).append(">").append(ExportXmlUtils.formatCdataSection(plainTextAsset.getContent())).append("</").append(TEXT_CONTENT).append(">");
        return sb.toString();
    }

    protected PlainTextAsset doParse(String name, String format, String lastContributor, String checkinComment, Date lastModified, Node assetNode) {
        String textContent = null;
        NodeList assetNodeList = assetNode.getChildNodes();
        for (int i = 0; i < assetNodeList.getLength(); ++i) {
            Node node = assetNodeList.item(i);
            String nodeContent = node.getTextContent();
            if (!TEXT_CONTENT.equalsIgnoreCase(node.getNodeName())) continue;
            textContent = nodeContent;
        }
        return new PlainTextAsset(name, format, lastContributor, checkinComment, lastModified, textContent);
    }
}

