/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.protocols.FORWARD_TO_COORD;
import org.jgroups.protocols.relay.CanBeSiteMaster;
import org.jgroups.protocols.relay.CanBeSiteMasterTopology;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TopologyUUID;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="RELAY2 protocol")
public class RELAY2
extends Protocol {
    @Property(description="Name of the site (needs to be defined in the configuration)", writable=false)
    protected String site;
    @Property(description="Name of the relay configuration", writable=false)
    protected String config;
    @Property(description="Whether or not this node can become the site master. If false, and we become the coordinator, we won't start the bridge(s)", writable=false)
    protected boolean can_become_site_master = true;
    @Property(description="Whether or not we generate our own addresses in which we use can_become_site_master. If this property is false, can_become_site_master is ignored")
    protected boolean enable_address_tagging = false;
    @Property(description="Whether or not to relay multicast (dest=null) messages")
    protected boolean relay_multicasts = true;
    @Property(description="The number of tries to forward a message to a remote site", deprecatedMessage="not used anymore, will be ignored")
    protected int max_forward_attempts = 5;
    @Property(description="The time (in milliseconds) to sleep between forward attempts", deprecatedMessage="not used anymore, will be ignored")
    protected long forward_sleep = 1000L;
    @Property(description="Max number of messages in the foward queue. Messages are added to the forward queue when the status of a route went from UP to UNKNOWN and the queue is flushed when the status goes to UP (resending all queued messages) or DOWN (sending SITE-UNREACHABLE messages to the senders)")
    protected int fwd_queue_max_size = 2000;
    @Property(description="Number of millisconds to wait when the status for a site changed from UP to UNKNOWN before that site is declared DOWN. A site that's DOWN triggers immediate sending of a SITE-UNREACHABLE message back to the sender of a message to that site")
    protected long site_down_timeout = 8000L;
    @Property(description="If true, the creation of the relay channel (and the connect()) are done in the background. Async relay creation is recommended, so the view callback won't be blocked")
    protected boolean async_relay_creation = true;
    @ManagedAttribute(description="My site-ID")
    protected short site_id = (short)-1;
    protected final Map<String, RelayConfig.SiteConfig> sites = new HashMap<String, RelayConfig.SiteConfig>();
    protected RelayConfig.SiteConfig site_config;
    @ManagedAttribute(description="Whether this member is the coordinator")
    protected volatile boolean is_coord = false;
    protected volatile Address coord;
    protected volatile Relayer relayer;
    protected TimeScheduler timer;
    protected volatile Address local_addr;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    @ManagedAttribute(description="FORWARD_TO_COORD protocol is present below the current protocol")
    protected boolean forwarding_protocol_present;
    @Property(description="If true, a received message can be forwarded to other members of the local cluster")
    protected boolean can_forward_local_cluster = false;
    protected short[] prots_above;

    public RELAY2 site(String site_name) {
        this.site = site_name;
        return this;
    }

    public RELAY2 config(String cfg) {
        this.config = cfg;
        return this;
    }

    public RELAY2 canBecomeSiteMaster(boolean flag) {
        this.can_become_site_master = flag;
        return this;
    }

    public RELAY2 enableAddressTagging(boolean flag) {
        this.enable_address_tagging = flag;
        return this;
    }

    public RELAY2 relayMulticasts(boolean flag) {
        this.relay_multicasts = flag;
        return this;
    }

    @Deprecated
    public RELAY2 maxForwardAttempts(int num) {
        return this;
    }

    @Deprecated
    public RELAY2 forwardSleep(long time) {
        return this;
    }

    public RELAY2 forwardQueueMaxSize(int size) {
        this.fwd_queue_max_size = size;
        return this;
    }

    public RELAY2 siteDownTimeout(long timeout) {
        this.site_down_timeout = timeout;
        return this;
    }

    public RELAY2 asyncRelayCreation(boolean flag) {
        this.async_relay_creation = flag;
        return this;
    }

    public String site() {
        return this.site;
    }

    public String config() {
        return this.config;
    }

    public boolean canBecomeSiteMaster() {
        return this.can_become_site_master;
    }

    public boolean enableAddressTagging() {
        return this.enable_address_tagging;
    }

    public boolean relayMulticasts() {
        return this.relay_multicasts;
    }

    public int forwardQueueMaxSize() {
        return this.fwd_queue_max_size;
    }

    public long siteDownTimeout() {
        return this.site_down_timeout;
    }

    public boolean asyncRelayCreation() {
        return this.async_relay_creation;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public View getBridgeView(String cluster_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getBridgeView(cluster_name) : null;
    }

    public RELAY2 addSite(String site_name, RelayConfig.SiteConfig cfg) {
        this.sites.put(site_name, cfg);
        return this;
    }

    @Override
    public void init() throws Exception {
        List<Integer> available_down_services;
        super.init();
        this.timer = this.getTransport().getTimer();
        if (this.site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (this.config != null) {
            this.parseSiteConfiguration(this.sites);
        }
        for (RelayConfig.SiteConfig cfg : this.sites.values()) {
            SiteUUID.addToCache(cfg.getId(), cfg.getName());
        }
        this.site_config = this.sites.get(this.site);
        if (this.site_config == null) {
            throw new Exception("site configuration for \"" + this.site + "\" not found in " + this.config);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": site configuration:\n" + this.site_config);
        }
        TreeSet<Short> site_ids = new TreeSet<Short>();
        for (RelayConfig.SiteConfig cfg : this.sites.values()) {
            site_ids.add(cfg.getId());
            if (!this.site.equals(cfg.getName())) continue;
            this.site_id = cfg.getId();
        }
        int index = 0;
        Iterator i$ = site_ids.iterator();
        while (i$.hasNext()) {
            int tmp_id = ((Short)i$.next()).shortValue();
            if (tmp_id != index) {
                throw new Exception("site IDs need to start with 0 and are required to increase monotonically; site IDs=" + site_ids);
            }
            ++index;
        }
        if (this.site_id < 0) {
            throw new IllegalArgumentException("site_id could not be determined from site \"" + this.site + "\"");
        }
        if (!this.site_config.getForwards().isEmpty()) {
            this.log.warn(this.local_addr + ": forwarding routes are currently not supported and will be ignored. This will change " + "with hierarchical routing (https://issues.jboss.org/browse/JGRP-1506)");
        }
        boolean bl = this.forwarding_protocol_present = (available_down_services = this.getDownServices()) != null && available_down_services.contains(105);
        if (!this.forwarding_protocol_present && this.log.isWarnEnabled()) {
            this.log.warn(this.local_addr + ": " + FORWARD_TO_COORD.class.getSimpleName() + " protocol not found below; " + "unable to re-submit messages to the new coordinator if the current coordinator crashes");
        }
        if (this.enable_address_tagging) {
            JChannel ch = this.getProtocolStack().getChannel();
            final AddressGenerator old_generator = ch.getAddressGenerator();
            ch.setAddressGenerator(new AddressGenerator(){

                @Override
                public Address generateAddress() {
                    if (old_generator != null) {
                        Address addr = old_generator.generateAddress();
                        if (addr instanceof TopologyUUID) {
                            return new CanBeSiteMasterTopology((TopologyUUID)addr, RELAY2.this.can_become_site_master);
                        }
                        if (addr instanceof UUID) {
                            return new CanBeSiteMaster((UUID)addr, RELAY2.this.can_become_site_master);
                        }
                        RELAY2.this.log.warn(RELAY2.this.local_addr + ": address generator is already set (" + old_generator + "); will replace it with own generator");
                    }
                    return CanBeSiteMaster.randomUUID(RELAY2.this.can_become_site_master);
                }
            });
        }
        this.prots_above = this.getIdsAbove();
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
        }
        if (this.relayer != null) {
            this.relayer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSiteConfiguration(Map<String, RelayConfig.SiteConfig> map) throws Exception {
        InputStream input = null;
        try {
            input = ConfiguratorFactory.getConfigStream(this.config);
            RelayConfig.parse(input, map);
        }
        finally {
            Util.close(input);
        }
    }

    @ManagedOperation(description="Prints the contents of the routing table. Only available if we're the current coordinator (site master)")
    public String printRoutes() {
        return this.relayer != null ? this.relayer.printRoutes() : "n/a (not site master)";
    }

    public JChannel getBridge(String site_name) {
        Relayer tmp = this.relayer;
        Relayer.Route route = tmp != null ? tmp.getRoute(SiteUUID.getSite(site_name)) : null;
        return route != null ? route.bridge() : null;
    }

    public Relayer.Route getRoute(String site_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getRoute(SiteUUID.getSite(site_name)) : null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                SiteUUID sender;
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || !(dest instanceof SiteAddress)) break;
                SiteAddress target = (SiteAddress)dest;
                Address src = msg.getSrc();
                SiteUUID siteUUID = sender = src instanceof SiteMaster ? new SiteMaster(((SiteMaster)src).getSite()) : new SiteUUID((UUID)this.local_addr, UUID.get(this.local_addr), this.site_id);
                if (target.getSite() == this.site_id) {
                    if (this.local_addr.equals(target) || target instanceof SiteMaster && this.is_coord) {
                        this.forwardTo(this.local_addr, target, sender, msg, false);
                    } else {
                        this.deliverLocally(target, sender, msg);
                    }
                    return null;
                }
                if (!this.is_coord) {
                    this.forwardTo(this.coord, target, sender, msg, true);
                } else {
                    this.route(target, sender, msg);
                }
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
                Address dest = msg.getDest();
                if (hdr == null) {
                    if (dest != null || !this.is_coord || !this.relay_multicasts || msg.isFlagSet(Message.Flag.NO_RELAY)) break;
                    SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), UUID.get(msg.getSrc()), this.site_id);
                    this.sendToBridges(sender, msg, this.site_id);
                    break;
                }
                if (dest != null) {
                    this.handleMessage(hdr, msg);
                } else {
                    this.deliver(null, hdr.original_sender, msg);
                }
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleRelayMessage(Relay2Header hdr, Message msg) {
        if (hdr.final_dest != null) {
            Message message = msg;
            Relay2Header header = hdr;
            if (header.type == 1 && this.can_forward_local_cluster) {
                SiteUUID site_uuid = (SiteUUID)hdr.final_dest;
                int index = (int)Util.random(this.members.size()) - 1;
                UUID tmp = (UUID)this.members.get(index);
                SiteUUID final_dest = new SiteUUID(tmp, site_uuid.getName(), site_uuid.getSite());
                if (!((Object)final_dest).equals(hdr.final_dest)) {
                    message = this.copy(msg);
                    header = new Relay2Header(1, final_dest, hdr.original_sender);
                    message.putHeader(this.id, header);
                }
            }
            this.handleMessage(header, message);
        } else {
            Message copy = this.copy(msg);
            copy.setDest(null);
            copy.setSrc(null);
            copy.putHeader(this.id, hdr);
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void handleMessage(Relay2Header hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.route((SiteAddress)hdr.final_dest, (SiteAddress)hdr.original_sender, msg);
                break;
            }
            case 2: {
                this.up_prot.up(new Event(104, hdr.final_dest));
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.log.error("type " + hdr.type + " unknown");
            }
        }
    }

    protected void route(SiteAddress dest, SiteAddress sender, Message msg) {
        short target_site = dest.getSite();
        if (target_site == this.site_id) {
            if (this.local_addr.equals(dest) || dest instanceof SiteMaster && this.is_coord) {
                this.deliver(dest, sender, msg);
            } else {
                this.deliverLocally(dest, sender, msg);
            }
            return;
        }
        Relayer tmp = this.relayer;
        if (tmp == null) {
            this.log.warn(this.local_addr + ": not site master; dropping message");
            return;
        }
        Relayer.Route route = tmp.getRoute(target_site);
        if (route == null) {
            this.log.error(this.local_addr + ": no route to " + SiteUUID.getSiteName(target_site) + ": dropping message");
        } else {
            route.send(target_site, dest, sender, msg);
        }
    }

    protected void sendToBridges(Address sender, Message msg, short ... excluded_sites) {
        List<Relayer.Route> routes;
        Relayer tmp = this.relayer;
        List<Relayer.Route> list = routes = tmp != null ? tmp.getRoutes(excluded_sites) : null;
        if (routes == null) {
            return;
        }
        for (Relayer.Route route : routes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": relaying multicast message from " + sender + " via route " + route);
            }
            try {
                route.send(((SiteAddress)route.siteMaster()).getSite(), null, sender, msg);
            }
            catch (Exception ex) {
                this.log.error(this.local_addr + ": failed relaying message from " + sender + " via route " + route, ex);
            }
        }
    }

    protected void sendSiteUnreachableTo(Address dest, short target_site) {
        Message msg = new Message(dest).setFlag(Message.Flag.OOB);
        msg.setSrc(new SiteUUID((UUID)this.local_addr, UUID.get(this.local_addr), this.site_id));
        Relay2Header hdr = new Relay2Header(2, new SiteMaster(target_site), null);
        msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, msg));
    }

    protected void forwardTo(Address next_dest, SiteAddress final_dest, Address original_sender, Message msg, boolean forward_to_current_coord) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": forwarding message to final destination " + final_dest + " to " + (forward_to_current_coord ? " the current coordinator" : next_dest));
        }
        Message copy = this.copy(msg).dest(next_dest).src(null);
        Relay2Header hdr = new Relay2Header(1, final_dest, original_sender);
        copy.putHeader(this.id, hdr);
        if (forward_to_current_coord && this.forwarding_protocol_present) {
            this.down_prot.down(new Event(105, copy));
        } else {
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void deliverLocally(SiteAddress dest, SiteAddress sender, Message msg) {
        Address local_dest;
        boolean send_to_coord = false;
        if (dest instanceof SiteUUID) {
            if (dest instanceof SiteMaster) {
                local_dest = this.coord;
                send_to_coord = true;
            } else {
                SiteUUID tmp = (SiteUUID)dest;
                local_dest = new UUID(tmp.getMostSignificantBits(), tmp.getLeastSignificantBits());
            }
        } else {
            local_dest = dest;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": delivering message to " + dest + " in local cluster");
        }
        this.forwardTo(local_dest, dest, sender, msg, send_to_coord);
    }

    protected void deliver(Address dest, Address sender, Message msg) {
        try {
            Message copy = this.copy(msg).dest(dest).src(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": delivering message from " + sender);
            }
            this.up_prot.up(new Event(1, copy));
        }
        catch (Exception e) {
            this.log.error("failed unmarshalling message", e);
        }
    }

    protected Message copy(Message msg) {
        return msg.copy(true, (short)200, this.prots_above);
    }

    protected void handleView(View view) {
        this.members = view.getMembers();
        Address old_coord = this.coord;
        Address new_coord = RELAY2.determineSiteMaster(view);
        boolean become_coord = new_coord.equals(this.local_addr) && (old_coord == null || !old_coord.equals(this.local_addr));
        boolean cease_coord = old_coord != null && old_coord.equals(this.local_addr) && !new_coord.equals(this.local_addr);
        this.coord = new_coord;
        if (become_coord) {
            this.is_coord = true;
            final String bridge_name = "_" + UUID.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            final Relayer tmp = this.relayer = new Relayer(this, this.log, this.sites.size());
            if (this.async_relay_creation) {
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        RELAY2.this.startRelayer(tmp, bridge_name);
                    }
                });
            } else {
                this.startRelayer(this.relayer, bridge_name);
            }
        } else if (cease_coord) {
            this.is_coord = false;
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
            }
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
    }

    protected void startRelayer(Relayer rel, String bridge_name) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": became site master; starting bridges");
            }
            rel.start(this.site_config.getBridges(), bridge_name, this.site_id);
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed starting relayer", t);
        }
    }

    protected static Address determineSiteMaster(View view) {
        List<Address> members = view.getMembers();
        for (Address member : members) {
            if ((!(member instanceof CanBeSiteMasterTopology) || !((CanBeSiteMasterTopology)member).canBecomeSiteMaster()) && (!(member instanceof CanBeSiteMaster) || !((CanBeSiteMaster)member).canBecomeSiteMaster())) continue;
            return member;
        }
        return Util.getCoordinator(view);
    }

    public static class Relay2Header
    extends Header {
        public static final byte DATA = 1;
        public static final byte SITE_UNREACHABLE = 2;
        public static final byte HOST_UNREACHABLE = 3;
        protected byte type;
        protected Address final_dest;
        protected Address original_sender;

        public Relay2Header() {
        }

        public Relay2Header(byte type, Address final_dest, Address original_sender) {
            this.type = type;
            this.final_dest = final_dest;
            this.original_sender = original_sender;
        }

        @Override
        public int size() {
            return 1 + Util.size(this.final_dest) + Util.size(this.original_sender);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeAddress(this.final_dest, out);
            Util.writeAddress(this.original_sender, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.final_dest = Util.readAddress(in);
            this.original_sender = Util.readAddress(in);
        }

        @Override
        public String toString() {
            return Relay2Header.typeToString(this.type) + " [dest=" + this.final_dest + ", sender=" + this.original_sender + "]";
        }

        protected static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "DATA";
                }
                case 2: {
                    return "SITE_UNREACHABLE";
                }
                case 3: {
                    return "HOST_UNREACHABLE";
                }
            }
            return "<unknown>";
        }
    }

    public static enum RouteStatus {
        UP,
        UNKNOWN,
        DOWN;

    }
}

