/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.Property;
import org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.screens.datamodeller.util.PersistenceDescriptorXMLMarshaller;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class PersistenceDescriptorServiceImpl
implements PersistenceDescriptorService {
    private static final String PERSISTENCE_DESCRIPTOR_PATH = "src/main/resources/META-INF/persistence.xml";
    private IOService ioService;
    private MetadataService metadataService;
    private CommentedOptionFactory optionsFactory;
    private KieProjectService projectService;

    public PersistenceDescriptorServiceImpl() {
    }

    @Inject
    public PersistenceDescriptorServiceImpl(@Named(value="ioStrategy") IOService ioService, KieProjectService projectService, MetadataService metadataService, CommentedOptionFactory optionsFactory) {
        this.ioService = ioService;
        this.projectService = projectService;
        this.metadataService = metadataService;
        this.optionsFactory = optionsFactory;
    }

    public PersistenceDescriptorModel load(org.uberfire.backend.vfs.Path path) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[0]));
            return PersistenceDescriptorXMLMarshaller.fromXML((InputStream)inputStream, (boolean)false);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public PersistenceDescriptorModel load(Project project) {
        org.uberfire.backend.vfs.Path descriptorPath = this.calculatePersistenceDescriptorPath(project);
        if (descriptorPath != null) {
            return this.load(descriptorPath);
        }
        return null;
    }

    public org.uberfire.backend.vfs.Path calculatePersistenceDescriptorPath(Project project) {
        org.uberfire.backend.vfs.Path rootPath;
        if (project == null || (rootPath = project.getRootPath()) == null) {
            return null;
        }
        Path nioRootPath = Paths.convert((org.uberfire.backend.vfs.Path)rootPath);
        org.uberfire.backend.vfs.Path descriptorPath = Paths.convert((Path)nioRootPath.resolve(PERSISTENCE_DESCRIPTOR_PATH));
        return descriptorPath;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, PersistenceDescriptorModel model, Metadata metadata, String comment) {
        try {
            Path result = null;
            String content = PersistenceDescriptorXMLMarshaller.toXML((PersistenceDescriptorModel)model);
            result = metadata != null ? this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), content, this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.optionsFactory.makeCommentedOption(comment)}) : (comment != null ? this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), content, new OpenOption[]{this.optionsFactory.makeCommentedOption(comment)}) : this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), content, new OpenOption[0]));
            return Paths.convert((Path)result);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, PersistenceDescriptorModel model) {
        return null;
    }

    public String toSource(org.uberfire.backend.vfs.Path path, PersistenceDescriptorModel model) {
        String content;
        try {
            content = PersistenceDescriptorXMLMarshaller.toXML((PersistenceDescriptorModel)model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        return content;
    }

    public PersistenceDescriptorModel createProjectDefaultDescriptor(org.uberfire.backend.vfs.Path path) {
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        if (project == null) {
            return null;
        }
        PersistenceDescriptorModel descriptorModel = new PersistenceDescriptorModel();
        descriptorModel.setVersion("2.0");
        PersistenceUnitModel unitModel = new PersistenceUnitModel();
        descriptorModel.setPersistenceUnit(unitModel);
        unitModel.setName(project.getPom().getGav().toString());
        unitModel.setTransactionType(TransactionType.JTA);
        unitModel.setProvider("org.hibernate.ejb.HibernatePersistence");
        unitModel.setJtaDataSource("java:jboss/datasources/ExampleDS");
        unitModel.addProperty(new Property("hibernate.dialect", "org.hibernate.dialect.H2Dialect"));
        unitModel.addProperty(new Property("hibernate.max_fetch_depth", "3"));
        unitModel.addProperty(new Property("hibernate.hbm2ddl.auto", "update"));
        unitModel.addProperty(new Property("hibernate.show_sql", "false"));
        unitModel.addProperty(new Property("hibernate.id.new_generator_mappings", "false"));
        unitModel.addProperty(new Property("hibernate.transaction.jta.platform", "org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform"));
        unitModel.setExcludeUnlistedClasses(Boolean.valueOf(true));
        return descriptorModel;
    }
}

