/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.kie.api.definition.rule.Rule;

public class SegmentUtilities {
    private static final int NOT_NODE_BIT = 1;
    private static final int JOIN_NODE_BIT = 2;
    private static final int REACTIVE_EXISTS_NODE_BIT = 4;
    private static final int PASSIVE_EXISTS_NODE_BIT = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SegmentMemory createSegmentMemory(LeftTupleSource tupleSource, InternalWorkingMemory wm) {
        InternalWorkingMemory internalWorkingMemory = wm;
        synchronized (internalWorkingMemory) {
            long allLinkedTestMask;
            int nodeTypesInSegment;
            LeftTupleSource segmentRoot;
            SegmentMemory smem;
            block25: {
                block24: {
                    LeftTupleSinkNode sink;
                    smem = wm.getNodeMemory((MemoryFactory)((Object)tupleSource)).getSegmentMemory();
                    if (smem != null) {
                        return smem;
                    }
                    while (!SegmentUtilities.isRootNode(tupleSource, null)) {
                        tupleSource = tupleSource.getLeftTupleSource();
                    }
                    segmentRoot = tupleSource;
                    nodeTypesInSegment = 0;
                    smem = SegmentUtilities.restoreSegmentFromPrototype(wm, segmentRoot, nodeTypesInSegment);
                    if (smem != null) {
                        return smem;
                    }
                    smem = new SegmentMemory(segmentRoot);
                    long nodePosMask = 1L;
                    allLinkedTestMask = 0L;
                    boolean updateNodeBit = true;
                    while (true) {
                        nodeTypesInSegment = SegmentUtilities.updateNodeTypesMask(tupleSource, nodeTypesInSegment);
                        if (NodeTypeEnums.isBetaNode(tupleSource)) {
                            allLinkedTestMask = SegmentUtilities.processBetaNode((BetaNode)tupleSource, wm, smem, nodePosMask, allLinkedTestMask, updateNodeBit);
                        } else {
                            switch (tupleSource.getType()) {
                                case 120: {
                                    allLinkedTestMask = SegmentUtilities.processLiaNode((LeftInputAdapterNode)tupleSource, wm, smem, nodePosMask, allLinkedTestMask);
                                    break;
                                }
                                case 131: {
                                    SegmentUtilities.processEvalNode((EvalConditionNode)tupleSource, wm, smem);
                                    break;
                                }
                                case 167: {
                                    updateNodeBit = SegmentUtilities.processBranchNode((ConditionalBranchNode)tupleSource, wm, smem);
                                    break;
                                }
                                case 151: {
                                    SegmentUtilities.processFromNode((FromNode)tupleSource, wm, smem);
                                    break;
                                }
                                case 153: {
                                    SegmentUtilities.processReactiveFromNode((MemoryFactory)((Object)tupleSource), wm, smem, nodePosMask);
                                    break;
                                }
                                case 133: {
                                    SegmentUtilities.processTimerNode((TimerNode)tupleSource, wm, smem, nodePosMask);
                                    break;
                                }
                                case 165: {
                                    updateNodeBit = SegmentUtilities.processQueryNode((QueryElementNode)tupleSource, wm, segmentRoot, smem, nodePosMask);
                                }
                            }
                        }
                        nodePosMask <<= 1;
                        if (tupleSource.getSinkPropagator().size() != 1) break block24;
                        sink = tupleSource.getSinkPropagator().getFirstLeftTupleSink();
                        if (!NodeTypeEnums.isLeftTupleSource(sink)) break;
                        tupleSource = (LeftTupleSource)((Object)sink);
                    }
                    Object memory = wm.getNodeMemory((MemoryFactory)((Object)sink));
                    if (sink.getType() == 71) {
                        ObjectSink[] nodes;
                        RiaPathMemory riaPmem = ((RightInputAdapterNode.RiaNodeMemory)memory).getRiaPathMemory();
                        smem.getNodeMemories().add(riaPmem);
                        RightInputAdapterNode rian = (RightInputAdapterNode)sink;
                        for (ObjectSink node : nodes = rian.getObjectSinkPropagator().getSinks()) {
                            if (!NodeTypeEnums.isLeftTupleSource(node)) continue;
                            SegmentUtilities.createSegmentMemory((LeftTupleSource)((Object)node), wm);
                        }
                    } else if (NodeTypeEnums.isTerminalNode(sink)) {
                        smem.getNodeMemories().add((Memory)memory);
                    }
                    memory.setSegmentMemory(smem);
                    smem.setTipNode(sink);
                    break block25;
                }
                smem.setTipNode(tupleSource);
            }
            smem.setAllLinkedMaskTest(allLinkedTestMask);
            LeftTupleSource pathRoot = segmentRoot;
            int ruleSegmentPosMask = 1;
            int counter = 0;
            while (pathRoot.getType() != 120) {
                if (SegmentUtilities.isRootNode(pathRoot, null)) {
                    ruleSegmentPosMask <<= 1;
                    ++counter;
                }
                pathRoot = pathRoot.getLeftTupleSource();
            }
            smem.setSegmentPosMaskBit(ruleSegmentPosMask);
            smem.setPos(counter);
            nodeTypesInSegment = SegmentUtilities.updateRiaAndTerminalMemory(tupleSource, tupleSource, smem, wm, false, nodeTypesInSegment);
            ((KnowledgeBaseImpl)wm.getKnowledgeBase()).registerSegmentPrototype(segmentRoot, smem);
            return smem;
        }
    }

    private static SegmentMemory restoreSegmentFromPrototype(InternalWorkingMemory wm, LeftTupleSource segmentRoot, int nodeTypesInSegment) {
        SegmentMemory smem = wm.getKnowledgeBase().createSegmentFromPrototype(wm, segmentRoot);
        if (smem != null) {
            for (NetworkNode node : smem.getNodesInSegment()) {
                wm.getNodeMemory((MemoryFactory)((Object)node)).setSegmentMemory(smem);
            }
            nodeTypesInSegment = SegmentUtilities.updateRiaAndTerminalMemory(segmentRoot, segmentRoot, smem, wm, true, nodeTypesInSegment);
        }
        return smem;
    }

    private static boolean processQueryNode(QueryElementNode queryNode, InternalWorkingMemory wm, LeftTupleSource segmentRoot, SegmentMemory smem, long nodePosMask) {
        SegmentMemory querySmem = SegmentUtilities.getQuerySegmentMemory(wm, segmentRoot, queryNode);
        QueryElementNode.QueryElementNodeMemory queryNodeMem = smem.createNodeMemory(queryNode, wm);
        queryNodeMem.setNodePosMaskBit(nodePosMask);
        queryNodeMem.setQuerySegmentMemory(querySmem);
        queryNodeMem.setSegmentMemory(smem);
        return !queryNode.getQueryElement().isAbductive();
    }

    public static SegmentMemory getQuerySegmentMemory(InternalWorkingMemory wm, LeftTupleSource segmentRoot, QueryElementNode queryNode) {
        LeftInputAdapterNode liaNode = SegmentUtilities.getQueryLiaNode(queryNode.getQueryElement().getQueryName(), SegmentUtilities.getQueryOtn(segmentRoot));
        LeftInputAdapterNode.LiaNodeMemory liam = wm.getNodeMemory(liaNode);
        SegmentMemory querySmem = liam.getSegmentMemory();
        if (querySmem == null) {
            querySmem = SegmentUtilities.createSegmentMemory(liaNode, wm);
        }
        return querySmem;
    }

    private static void processFromNode(MemoryFactory tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        ((FromNode.FromMemory)smem.createNodeMemory(tupleSource, wm)).getBetaMemory().setSegmentMemory(smem);
    }

    private static void processReactiveFromNode(MemoryFactory tupleSource, InternalWorkingMemory wm, SegmentMemory smem, long nodePosMask) {
        BetaMemory bm = ((FromNode.FromMemory)smem.createNodeMemory(tupleSource, wm)).getBetaMemory();
        bm.setSegmentMemory(smem);
        bm.setNodePosMaskBit(nodePosMask);
    }

    private static boolean processBranchNode(ConditionalBranchNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        ConditionalBranchNode.ConditionalBranchMemory branchMem = smem.createNodeMemory(tupleSource, wm);
        branchMem.setSegmentMemory(smem);
        return false;
    }

    private static void processEvalNode(EvalConditionNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        EvalConditionNode.EvalMemory evalMem = smem.createNodeMemory(tupleSource, wm);
        evalMem.setSegmentMemory(smem);
    }

    private static void processTimerNode(TimerNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem, long nodePosMask) {
        TimerNode.TimerNodeMemory tnMem = smem.createNodeMemory(tupleSource, wm);
        tnMem.setNodePosMaskBit(nodePosMask);
        tnMem.setSegmentMemory(smem);
    }

    private static long processLiaNode(LeftInputAdapterNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem, long nodePosMask, long allLinkedTestMask) {
        LeftInputAdapterNode.LiaNodeMemory liaMemory = smem.createNodeMemory(tupleSource, wm);
        liaMemory.setSegmentMemory(smem);
        liaMemory.setNodePosMaskBit(nodePosMask);
        return allLinkedTestMask |= nodePosMask;
    }

    private static long processBetaNode(BetaNode betaNode, InternalWorkingMemory wm, SegmentMemory smem, long nodePosMask, long allLinkedTestMask, boolean updateNodeBit) {
        BetaMemory bm = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)smem.createNodeMemory(betaNode, wm)).getBetaMemory() : (BetaMemory)smem.createNodeMemory(betaNode, wm);
        bm.setSegmentMemory(smem);
        if (betaNode.isRightInputIsRiaNode()) {
            RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
            LeftTupleSource subnetworkLts = riaNode.getLeftTupleSource();
            while (subnetworkLts.getLeftTupleSource() != riaNode.getStartTupleSource()) {
                subnetworkLts = subnetworkLts.getLeftTupleSource();
            }
            Object rootSubNetwokrMem = wm.getNodeMemory((MemoryFactory)((Object)subnetworkLts));
            SegmentMemory subNetworkSegmentMemory = rootSubNetwokrMem.getSegmentMemory();
            if (subNetworkSegmentMemory == null) {
                SegmentUtilities.createSegmentMemory(subnetworkLts, wm);
            }
            RightInputAdapterNode.RiaNodeMemory riaMem = wm.getNodeMemory(riaNode);
            bm.setRiaRuleMemory(riaMem.getRiaPathMemory());
            if (updateNodeBit && SegmentUtilities.canBeDisabled(betaNode) && riaMem.getRiaPathMemory().getAllLinkedMaskTest() > 0L) {
                allLinkedTestMask |= nodePosMask;
            }
        } else if (updateNodeBit && SegmentUtilities.canBeDisabled(betaNode)) {
            allLinkedTestMask |= nodePosMask;
        }
        bm.setNodePosMaskBit(nodePosMask);
        if (191 == betaNode.getType()) {
            smem.linkNodeWithoutRuleNotify(bm.getNodePosMaskBit());
        }
        return allLinkedTestMask;
    }

    private static boolean canBeDisabled(BetaNode betaNode) {
        return (191 != betaNode.getType() || ((NotNode)betaNode).isEmptyBetaConstraints()) && 211 != betaNode.getType() && !betaNode.isRightInputPassive();
    }

    public static void createChildSegments(InternalWorkingMemory wm, SegmentMemory smem, LeftTupleSinkPropagator sinkProp) {
        if (!smem.isEmpty()) {
            return;
        }
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            SegmentMemory childSmem = SegmentUtilities.createChildSegment(wm, sink);
            childSmem.setPos(smem.getPos() + 1);
            smem.add(childSmem);
        }
    }

    public static SegmentMemory createChildSegment(InternalWorkingMemory wm, LeftTupleNode node) {
        Object memory = wm.getNodeMemory((MemoryFactory)((Object)node));
        if (!NodeTypeEnums.isEndNode(node)) {
            if (memory.getSegmentMemory() == null) {
                SegmentUtilities.createSegmentMemory((LeftTupleSource)node, wm);
            }
        } else if (memory.getSegmentMemory() == null) {
            SegmentUtilities.createChildSegmentForTerminalNode(node, memory);
        }
        return memory.getSegmentMemory();
    }

    public static SegmentMemory createChildSegmentForTerminalNode(LeftTupleNode node, Memory memory) {
        SegmentMemory childSmem = new SegmentMemory(node);
        PathMemory pmem = NodeTypeEnums.isTerminalNode(node) ? (PathMemory)memory : ((RightInputAdapterNode.RiaNodeMemory)memory).getRiaPathMemory();
        childSmem.setPos(pmem.getSegmentMemories().length - 1);
        pmem.setSegmentMemory(childSmem.getPos(), childSmem);
        pmem.setSegmentMemory(childSmem);
        childSmem.addPathMemory(pmem);
        childSmem.setTipNode(node);
        return childSmem;
    }

    public static boolean inSubNetwork(RightInputAdapterNode riaNode, LeftTupleSource leftTupleSource) {
        LeftTupleSource startTupleSource = riaNode.getStartTupleSource();
        for (LeftTupleSource parent = riaNode.getLeftTupleSource(); parent != startTupleSource; parent = parent.getLeftTupleSource()) {
            if (parent != leftTupleSource) continue;
            return true;
        }
        return false;
    }

    private static int updateRiaAndTerminalMemory(LeftTupleSource lt, LeftTupleSource originalLt, SegmentMemory smem, InternalWorkingMemory wm, boolean fromPrototype, int nodeTypesInSegment) {
        nodeTypesInSegment = SegmentUtilities.checkSegmentBoundary(lt, wm, nodeTypesInSegment);
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                nodeTypesInSegment = SegmentUtilities.updateRiaAndTerminalMemory((LeftTupleSource)((Object)sink), originalLt, smem, wm, fromPrototype, nodeTypesInSegment);
                continue;
            }
            if (sink.getType() == 71) {
                ObjectSink[] nodes;
                if (!SegmentUtilities.inSubNetwork((RightInputAdapterNode)sink, originalLt)) continue;
                RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                RiaPathMemory pmem = riaMem.getRiaPathMemory();
                smem.addPathMemory(pmem);
                if (smem.getPos() < pmem.getSegmentMemories().length) {
                    pmem.setSegmentMemory(smem.getPos(), smem);
                }
                if (fromPrototype) {
                    for (ObjectSink node : nodes = ((RightInputAdapterNode)sink).getObjectSinkPropagator().getSinks()) {
                        if (!NodeTypeEnums.isLeftTupleSource(node) || wm.getNodeMemory((MemoryFactory)((Object)node)).getSegmentMemory() != null) continue;
                        SegmentUtilities.restoreSegmentFromPrototype(wm, (LeftTupleSource)((Object)node), nodeTypesInSegment);
                    }
                    continue;
                }
                if ((pmem.getAllLinkedMaskTest() & 1L << pmem.getSegmentMemories().length) != 0L) continue;
                for (ObjectSink node : nodes = ((RightInputAdapterNode)sink).getObjectSinkPropagator().getSinks()) {
                    if (!NodeTypeEnums.isLeftTupleSource(node)) continue;
                    SegmentUtilities.createSegmentMemory((LeftTupleSource)((Object)node), wm);
                }
                continue;
            }
            if (!NodeTypeEnums.isTerminalNode(sink)) continue;
            PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
            smem.addPathMemory(pmem);
            if (smem.getPos() >= pmem.getSegmentMemories().length) continue;
            pmem.setSegmentMemory(smem.getPos(), smem);
            if (smem.isSegmentLinked()) {
                smem.notifyRuleLinkSegment(wm);
            }
            SegmentUtilities.checkEagerSegmentCreation(sink.getLeftTupleSource(), wm, nodeTypesInSegment);
        }
        return nodeTypesInSegment;
    }

    private static int checkSegmentBoundary(LeftTupleSource lt, InternalWorkingMemory wm, int nodeTypesInSegment) {
        if (SegmentUtilities.isRootNode(lt, null)) {
            SegmentUtilities.checkEagerSegmentCreation(lt.getLeftTupleSource(), wm, nodeTypesInSegment);
            nodeTypesInSegment = 0;
        }
        return SegmentUtilities.updateNodeTypesMask(lt, nodeTypesInSegment);
    }

    private static void checkEagerSegmentCreation(LeftTupleSource lt, InternalWorkingMemory wm, int nodeTypesInSegment) {
        if (SegmentUtilities.isSet(nodeTypesInSegment, 1) && !SegmentUtilities.isSet(nodeTypesInSegment, 2) && !SegmentUtilities.isSet(nodeTypesInSegment, 4)) {
            SegmentUtilities.createSegmentMemory(lt, wm);
        }
    }

    public static boolean isRootNode(LeftTupleNode node, Rule removingRule) {
        if (node.getType() == 120) {
            return true;
        }
        LeftTupleSource parent = node.getLeftTupleSource();
        return SegmentUtilities.isTipNode(parent, removingRule);
    }

    public static boolean isTipNode(LeftTupleNode node, Rule removingRule) {
        if (NodeTypeEnums.isEndNode(node)) {
            return true;
        }
        LeftTupleSinkPropagator sinkPropagator = ((LeftTupleSource)node).getSinkPropagator();
        if (removingRule == null) {
            return sinkPropagator.size() > 1;
        }
        if (sinkPropagator.size() == 1) {
            return false;
        }
        int count = 0;
        for (LeftTupleSinkNode sink = sinkPropagator.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            int associatedRuleSize = sink.getAssociatedRuleSize();
            if (associatedRuleSize == 1 && sink.isAssociatedWith(removingRule) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public static ObjectTypeNode getQueryOtn(LeftTupleSource lts) {
        while (!(lts instanceof LeftInputAdapterNode)) {
            lts = lts.getLeftTupleSource();
        }
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)lts;
        ObjectSource os = liaNode.getObjectSource();
        while (!(os instanceof EntryPointNode)) {
            os = os.getParentObjectSource();
        }
        return ((EntryPointNode)os).getQueryNode();
    }

    public static LeftInputAdapterNode getQueryLiaNode(String queryName, ObjectTypeNode queryOtn) {
        if (queryOtn.getObjectSinkPropagator() instanceof CompositeObjectSinkAdapter) {
            CompositeObjectSinkAdapter sink = (CompositeObjectSinkAdapter)queryOtn.getObjectSinkPropagator();
            if (sink.getHashableSinks() != null) {
                for (AlphaNode alphaNode = (AlphaNode)sink.getHashableSinks().getFirst(); alphaNode != null; alphaNode = (AlphaNode)alphaNode.getNextObjectSinkNode()) {
                    QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
                    if (!queryName.equals(nameConstraint.getQueryName())) continue;
                    return (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
                }
            }
            Iterator it = sink.getHashedSinkMap().iterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                AlphaNode alphaNode = (AlphaNode)entry.getValue();
                QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
                if (queryName.equals(nameConstraint.getQueryName())) {
                    return (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
                }
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        } else {
            AlphaNode alphaNode = (AlphaNode)queryOtn.getObjectSinkPropagator().getSinks()[0];
            QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
            if (queryName.equals(nameConstraint.getQueryName())) {
                return (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
            }
            return (LeftInputAdapterNode)queryOtn.getObjectSinkPropagator().getSinks()[0];
        }
        throw new RuntimeException("Unable to find query '" + queryName + "'");
    }

    private static int updateNodeTypesMask(NetworkNode node, int mask) {
        switch (node.getType()) {
            case 181: {
                mask |= 2;
                break;
            }
            case 201: {
                if (((ExistsNode)node).isRightInputPassive()) {
                    mask |= 8;
                    break;
                }
                mask |= 4;
                break;
            }
            case 191: {
                mask |= 1;
            }
        }
        return mask;
    }

    public static boolean isSet(int mask, int bit) {
        return (mask & bit) == bit;
    }
}

