/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.WindowTupleList;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFactHandle
extends DefaultFactHandle
implements Comparable<EventFactHandle> {
    private static final long serialVersionUID = 510L;
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private long activationsCount;
    private long pendingActions;
    private WindowTupleList firstWindowTuple;
    private WindowTupleList lastWindowTuple;

    public EventFactHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, object, recency, timestamp, duration, wmEntryPoint, false);
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        super(id, object, recency, wmEntryPoint, isTraitOrTraitable);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    @Override
    public String toExternalForm() {
        return "1:" + super.getId() + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (super.getEntryPoint() != null ? super.getEntryPoint().getEntryPointId() : "null");
    }

    @Override
    public String toString() {
        return this.toExternalForm();
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public long getActivationsCount() {
        return this.activationsCount;
    }

    public void setActivationsCount(long activationsCount) {
        this.activationsCount = activationsCount;
    }

    public void increaseActivationsCount() {
        ++this.activationsCount;
    }

    public void decreaseActivationsCount() {
        --this.activationsCount;
    }

    public void addFirstWindowTupleList(WindowTupleList window) {
        WindowTupleList previous = this.firstWindowTuple;
        if (previous == null) {
            window.setListPrevious(null);
            window.setListNext(null);
            this.firstWindowTuple = window;
            this.lastWindowTuple = window;
        } else {
            window.setListPrevious(null);
            window.setListNext(previous);
            previous.setListPrevious(window);
            this.firstWindowTuple = window;
        }
    }

    public void addLastWindowTupleList(WindowTupleList window) {
        WindowTupleList previous = this.lastWindowTuple;
        if (previous == null) {
            window.setListPrevious(null);
            window.setListNext(null);
            this.firstWindowTuple = window;
            this.lastWindowTuple = window;
        } else {
            window.setListPrevious(previous);
            window.setListNext(null);
            previous.setListNext(window);
            this.lastWindowTuple = window;
        }
    }

    public void removeWindowTupleList(WindowTupleList window) {
        WindowTupleList previous = window.getListPrevious();
        WindowTupleList next = window.getListNext();
        if (previous != null && next != null) {
            previous.setListNext(next);
            next.setListPrevious(previous);
        } else if (next != null) {
            next.setListPrevious(null);
            this.firstWindowTuple = next;
        } else if (previous != null) {
            previous.setListNext(null);
            this.lastWindowTuple = previous;
        } else {
            this.firstWindowTuple = null;
            this.lastWindowTuple = null;
        }
        window.setListPrevious(null);
        window.setListNext(null);
    }

    @Override
    public EventFactHandle clone() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getObject(), this.getRecency(), this.startTimestamp, this.duration, this.getEntryPoint(), this.isTraitOrTraitable());
        clone.activationsCount = this.activationsCount;
        clone.expired = this.expired;
        clone.setEntryPoint(this.getEntryPoint());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setFirstLeftTuple(this.getLastLeftTuple());
        clone.setLastLeftTuple(this.getLastLeftTuple());
        clone.setFirstRightTuple(this.getFirstRightTuple());
        clone.setLastRightTuple(this.getLastRightTuple());
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.firstWindowTuple = this.firstWindowTuple;
        clone.lastWindowTuple = this.lastWindowTuple;
        return clone;
    }

    @Override
    public int compareTo(EventFactHandle e) {
        return this.getStartTimestamp() < e.getStartTimestamp() ? -1 : (this.getStartTimestamp() == e.getStartTimestamp() ? 0 : 1);
    }

    public synchronized boolean hasPendingActions() {
        return this.pendingActions > 0L;
    }

    public synchronized void incPendingActions() {
        ++this.pendingActions;
    }

    public synchronized void decPendingActions() {
        --this.pendingActions;
    }
}

