/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.NormalizedTerms;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.FieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.TypeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindTypeFieldsQuery
implements NamedQuery {
    public static String FIND_TYPE_FIELDS_QUERY = "FindTypeFieldsQuery";
    @Inject
    private DefaultResponseBuilder responseBuilder;

    @Override
    public String getName() {
        return FIND_TYPE_FIELDS_QUERY;
    }

    @Override
    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new TypeIndexTerm());
                this.add(new FieldIndexTerm());
            }
        };
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        NormalizedTerms normalizedTerms = new NormalizedTerms(terms, "typeName", "field");
        BasicQueryBuilder builder = new BasicQueryBuilder(useWildcards);
        builder.addTerm(normalizedTerms.get("typeName")).addTerm(normalizedTerms.get("field"));
        return builder.build();
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

