/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.regexp.shared.RegExp;
import org.drools.guvnor.client.common.AbstractRestrictedEntryTextBox;

public class NumericDoubleTextBox
extends AbstractRestrictedEntryTextBox {
    private static final RegExp VALID = RegExp.compile((String)"(^[-]?[0-9]*\\.?[0-9]*$)");

    public NumericDoubleTextBox() {
        super(false);
    }

    public NumericDoubleTextBox(boolean allowEmptyValue) {
        super(allowEmptyValue);
    }

    @Override
    public boolean isValidValue(String value, boolean isOnFocusLost) {
        boolean isValid = VALID.test(value);
        if (!isValid) {
            return isValid;
        }
        if (!isOnFocusLost && "-".equals(value)) {
            return true;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            isValid = "".equals(value) && this.allowEmptyValue;
        }
        return isValid;
    }

    @Override
    protected String makeValidValue(String value) {
        return "0.0";
    }
}

