/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.modules;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.IsTreeItem;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeItemBaseView;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.util.Util;

public abstract class ModulesTreeItemBaseViewImpl
implements ModulesTreeItemBaseView {
    protected static final ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    protected static final ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    protected final Tree tree = new Tree();
    protected ModulesTreeItemBaseView.Presenter presenter;

    public ModulesTreeItemBaseViewImpl() {
        this.tree.setStyleName("guvnor-Tree");
        this.tree.setAnimationEnabled(true);
        this.addSelectionHandler();
    }

    private void addSelectionHandler() {
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> treeItemSelectionEvent) {
                ModulesTreeItemBaseViewImpl.this.presenter.onModuleSelected(((TreeItem)treeItemSelectionEvent.getSelectedItem()).getUserObject());
            }
        });
    }

    @Override
    public void setPresenter(ModulesTreeItemBaseView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public IsTreeItem addModulesTreeItem() {
        return this.tree.addItem(this.getTreeHeader());
    }

    protected abstract SafeHtml getTreeHeader();

    @Override
    public IsTreeItem addModuleTreeItem(IsTreeItem parentTreeItem, String moduleName) {
        return parentTreeItem.asTreeItem().addItem(Util.getHeader(images.emptyPackage(), moduleName));
    }

    @Override
    public IsTreeItem addModuleTreeSelectableItem(IsTreeItem parentTreeItem, String moduleName) {
        return parentTreeItem.asTreeItem().addItem(Util.getHeader(images.packages(), moduleName));
    }

    public Widget asWidget() {
        return this.tree;
    }
}

