/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ClockType;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ListenerType;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.MarshallingOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.SessionType;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.guvnor.shared.api.PortableObject;

public class ServiceKSessionConfig
implements PortableObject {
    private static final long serialVersionUID = -7079787988244078946L;
    private String name;
    private String url;
    private ProtocolOption protocol;
    private MarshallingOption marshalling;
    private SessionType type;
    private ClockType clockType;
    private Boolean keepReference;
    private Map<ListenerType, Set<String>> listeners;

    public ServiceKSessionConfig() {
    }

    public ServiceKSessionConfig(String name) {
        this.setupNewInstance(name, name, SessionType.STATELESS, ProtocolOption.REST, MarshallingOption.XSTREAM, null, null, null);
    }

    public ServiceKSessionConfig(ServiceKSessionConfig ksession) {
        Preconditions.checkNotNull((String)"ksession", (Object)ksession);
        this.setupNewInstance(ksession.name, ksession.url, ksession.type, ksession.protocol, ksession.marshalling, ksession.clockType, ksession.keepReference, ksession.listeners);
    }

    public ServiceKSessionConfig(String name, String url, SessionType type, ProtocolOption protocol, MarshallingOption marshalling, ClockType clockType, Boolean keepReference, Map<ListenerType, Set<String>> listeners) {
        this.setupNewInstance(name, url, type, protocol, marshalling, clockType, keepReference, listeners);
    }

    public ServiceKSessionConfig(String name, ServiceKSessionConfig ksession) {
        Preconditions.checkNotNull((String)"ksession", (Object)ksession);
        Preconditions.checkNotEmpty((String)"name", (String)name);
        this.setupNewInstance(name, ksession.url, ksession.type, ksession.protocol, ksession.marshalling, ksession.clockType, ksession.keepReference, ksession.listeners);
    }

    private void setupNewInstance(String name, String url, SessionType type, ProtocolOption protocol, MarshallingOption marshalling, ClockType clockType, Boolean keepReference, Map<ListenerType, Set<String>> listeners) {
        this.name = Preconditions.checkNotEmpty((String)"name", (String)name);
        this.url = url == null ? name : url;
        this.type = type == null ? SessionType.STATELESS : type;
        this.protocol = protocol == null ? ProtocolOption.REST : protocol;
        this.marshalling = marshalling == null ? MarshallingOption.XSTREAM : marshalling;
        this.clockType = clockType;
        this.keepReference = keepReference;
        this.listeners = listeners != null ? new HashMap<ListenerType, Set<String>>(listeners) : new HashMap<ListenerType, Set<String>>();
    }

    public boolean hasConfig() {
        return this.clockType != null || this.keepReference != null || this.getListeners().size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public SessionType getType() {
        return this.type;
    }

    public ProtocolOption getProtocol() {
        return this.protocol;
    }

    public MarshallingOption getMarshalling() {
        return this.marshalling;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public Boolean getKeepReference() {
        return this.keepReference;
    }

    public void setUrl(String url) {
        this.url = Preconditions.checkNotEmpty((String)"url", (String)url);
    }

    public void setType(SessionType type) {
        this.type = (SessionType)((Object)Preconditions.checkNotNull((String)"type", (Object)((Object)type)));
    }

    public void setProtocol(ProtocolOption protocol) {
        this.protocol = (ProtocolOption)((Object)Preconditions.checkNotNull((String)"protocol", (Object)((Object)protocol)));
    }

    public void setMarshalling(MarshallingOption marshalling) {
        this.marshalling = (MarshallingOption)((Object)Preconditions.checkNotNull((String)"marshalling", (Object)((Object)marshalling)));
    }

    public void setClockType(ClockType clockType) {
        this.clockType = (ClockType)((Object)Preconditions.checkNotNull((String)"clockType", (Object)((Object)clockType)));
    }

    public void setClockTypeToNull() {
        this.clockType = null;
    }

    public void setKeepReference(boolean keepReference) {
        this.keepReference = keepReference;
    }

    public void setKeepReferenceToNull() {
        this.keepReference = null;
    }

    public void addAgendaListener(String className) {
        this.addListerner(ListenerType.AGENDA, className);
    }

    public void removeAgendaListener(String className) {
        this.removeListerner(ListenerType.AGENDA, className);
    }

    public void addProcessListener(String className) {
        this.addListerner(ListenerType.PROCESS, className);
    }

    public void removeProcessListener(String className) {
        this.removeListerner(ListenerType.PROCESS, className);
    }

    public void addWorkingMemoryListener(String className) {
        this.addListerner(ListenerType.WORKING_MEMORY, className);
    }

    public void removeWorkingMemoryListener(String className) {
        this.removeListerner(ListenerType.WORKING_MEMORY, className);
    }

    public Collection<String> getAgendaListeners() {
        return this.getListeners(ListenerType.AGENDA);
    }

    public Collection<String> getProcessListeners() {
        return this.getListeners(ListenerType.PROCESS);
    }

    public Collection<String> getWorkingMemoryListeners() {
        return this.getListeners(ListenerType.WORKING_MEMORY);
    }

    public Collection<String> getListeners() {
        HashSet<String> result = new HashSet<String>();
        for (Set<String> activeSet : this.listeners.values()) {
            result.addAll(activeSet);
        }
        return result;
    }

    private Collection<String> getListeners(ListenerType type) {
        if (!this.listeners.containsKey((Object)type)) {
            return Collections.emptyList();
        }
        return this.listeners.get((Object)type);
    }

    private void addListerner(ListenerType type, String className) {
        Preconditions.checkNotNull((String)"type", (Object)((Object)type));
        Preconditions.checkNotEmpty((String)"className", (String)className);
        if (!this.listeners.containsKey((Object)type)) {
            this.listeners.put(type, new HashSet());
        }
        this.listeners.get((Object)type).add(className);
    }

    private void removeListerner(ListenerType type, String className) {
        if (className == null || className.trim().equals("")) {
            return;
        }
        Preconditions.checkNotNull((String)"type", (Object)((Object)type));
        if (!this.listeners.containsKey((Object)type)) {
            return;
        }
        this.listeners.get((Object)type).remove(className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceKSessionConfig that = (ServiceKSessionConfig)o;
        if (this.clockType != that.clockType) {
            return false;
        }
        if (this.keepReference != null ? !this.keepReference.equals(that.keepReference) : that.keepReference != null) {
            return false;
        }
        if (this.listeners != null ? !((Object)this.listeners).equals(that.listeners) : that.listeners != null) {
            return false;
        }
        if (this.marshalling != that.marshalling) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.protocol != that.protocol) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.protocol.hashCode();
        result = 31 * result + this.marshalling.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.clockType != null ? this.clockType.hashCode() : 0);
        result = 31 * result + (this.keepReference != null ? this.keepReference.hashCode() : 0);
        result = 31 * result + (this.listeners != null ? ((Object)this.listeners).hashCode() : 0);
        return result;
    }
}

