/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.widgets.drools.explorer.AbstractResourceDefinitionExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageDisplayMode;
import org.drools.guvnor.client.widgets.drools.explorer.ResourceElementReadyCommand;
import org.drools.guvnor.client.widgets.tables.AssetPagedTable;

public class AssetResourceExplorerWidget
extends AbstractResourceDefinitionExplorerWidget {
    private boolean globalArea;
    private ModuleServiceAsync packageService;
    private final AssetServiceAsync assetService;
    private ClientFactory clientFactory;
    private String packageUUID;
    private final PackageDisplayMode packageDisplayMode;
    private static CreateAssetResourceWidgetBinder uiBinder = (CreateAssetResourceWidgetBinder)GWT.create(CreateAssetResourceWidgetBinder.class);
    @UiField
    protected TextBox txtName;
    @UiField
    protected TextBox txtDescription;
    @UiField
    protected ListBox lstPackage;
    @UiField
    protected ListBox lstFormat;
    @UiField
    protected ScrollPanel sclTreePanel;
    @UiField
    protected Label labelName;
    @UiField
    protected Label labelDescr;
    protected AssetPagedTable assetsTable;

    public AssetResourceExplorerWidget(String packageUUID, String packageName, ClientFactory clientFactory, String[] formatList, ExplorerRenderMode mode, PackageDisplayMode packageDisplayMode) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.globalArea = packageName.equals("globalArea");
        this.packageService = clientFactory.getModuleService();
        this.assetService = clientFactory.getAssetService();
        this.clientFactory = clientFactory;
        this.packageDisplayMode = packageDisplayMode;
        this.packageUUID = packageUUID;
        this.initializeFormatList(formatList);
        this.initializePackageList();
        if (mode.equals((Object)ExplorerRenderMode.HIDE_NAME_AND_DESCRIPTION)) {
            this.txtName.setVisible(false);
            this.txtDescription.setVisible(false);
            this.labelName.setVisible(false);
            this.labelDescr.setVisible(false);
        }
    }

    private void initializePackageList() {
        if (this.globalArea || this.packageDisplayMode.equals((Object)PackageDisplayMode.ALL_PACKAGES)) {
            this.packageService.loadGlobalModule((AsyncCallback)new AsyncCallback<Module>(){

                public void onFailure(Throwable caught) {
                    ErrorPopup.showMessage((String)"Error listing Global Area information!");
                }

                public void onSuccess(Module result) {
                    AssetResourceExplorerWidget.this.populatePackageList(result, AssetResourceExplorerWidget.this.packageUUID);
                }
            });
            this.packageService.listModules((AsyncCallback)new AsyncCallback<Module[]>(){

                public void onFailure(Throwable caught) {
                    ErrorPopup.showMessage((String)"Error listing package information!");
                }

                public void onSuccess(Module[] result) {
                    for (int i = 0; i < result.length; ++i) {
                        Module packageConfigData = result[i];
                        AssetResourceExplorerWidget.this.populatePackageList(packageConfigData, AssetResourceExplorerWidget.this.packageUUID);
                    }
                    AssetResourceExplorerWidget.this.loadAssetTable();
                }
            });
        } else {
            this.packageService.loadModule(this.packageUUID, (AsyncCallback)new AsyncCallback<Module>(){

                public void onFailure(Throwable caught) {
                    ErrorPopup.showMessage((String)"Error listing package information!");
                }

                public void onSuccess(Module result) {
                    AssetResourceExplorerWidget.this.populatePackageList(result, null);
                    AssetResourceExplorerWidget.this.loadAssetTable();
                }
            });
        }
        this.lstPackage.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                AssetResourceExplorerWidget.this.handleListChanges(event);
            }
        });
    }

    private void initializeFormatList(String[] formatList) {
        for (String format : formatList) {
            this.lstFormat.addItem(format, format);
        }
        this.lstFormat.setSelectedIndex(0);
        this.lstFormat.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                AssetResourceExplorerWidget.this.handleListChanges(event);
            }
        });
    }

    private void loadAssetTable() {
        this.sclTreePanel.clear();
        String selectedPackageUUID = this.lstPackage.getValue(this.lstPackage.getSelectedIndex());
        ArrayList<String> selectedFormats = new ArrayList<String>();
        selectedFormats.add(this.lstFormat.getValue(this.lstFormat.getSelectedIndex()));
        this.assetsTable = new AssetPagedTable(selectedPackageUUID, selectedFormats, null, this.clientFactory);
        this.sclTreePanel.add((Widget)this.assetsTable);
        this.makeDirty();
    }

    private void handleListChanges(ChangeEvent event) {
        this.loadAssetTable();
    }

    private void populatePackageList(Module packageConfigData, String uuidToBeSelected) {
        this.lstPackage.addItem(packageConfigData.getName(), packageConfigData.getUuid());
        if (uuidToBeSelected == null) {
            this.lstPackage.setSelectedIndex(0);
        } else if (packageConfigData.getUuid().equals(uuidToBeSelected)) {
            this.lstPackage.setSelectedIndex(this.lstPackage.getItemCount() - 1);
        }
    }

    @Override
    public void processSelectedResources(final ResourceElementReadyCommand command) {
        String[] selectedRowUUIDs = this.assetsTable.getSelectedRowUUIDs();
        if (selectedRowUUIDs == null || selectedRowUUIDs.length == 0) {
            throw new IllegalStateException(Constants.INSTANCE.NoPackageSeleced());
        }
        this.assetService.loadRuleAssets(selectedRowUUIDs, (AsyncCallback)new AsyncCallback<Asset[]>(){

            public void onFailure(Throwable caught) {
                command.onFailure(caught);
            }

            public void onSuccess(Asset[] assets) {
                command.onSuccess(AssetResourceExplorerWidget.this.lstPackage.getItemText(AssetResourceExplorerWidget.this.lstPackage.getSelectedIndex()), assets, AssetResourceExplorerWidget.this.txtName.getText(), AssetResourceExplorerWidget.this.txtDescription.getText());
            }
        });
    }

    static interface CreateAssetResourceWidgetBinder
    extends UiBinder<Widget, AssetResourceExplorerWidget> {
    }
}

