/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import java.util.Collection;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.common.InternalFactHandle;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromExternalFactHandleCommand
implements GenericCommand<FactHandle> {
    private String factHandleExternalForm;
    private boolean disconnected;

    public FromExternalFactHandleCommand(String factHandleExternalForm) {
        this(factHandleExternalForm, false);
    }

    public FromExternalFactHandleCommand(String factHandleExternalForm, boolean disconnected) {
        this.factHandleExternalForm = factHandleExternalForm;
        this.disconnected = disconnected;
    }

    @Override
    public FactHandle execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        Collection factHandles = ksession.getFactHandles();
        int fhId = Integer.parseInt(this.factHandleExternalForm.split(":")[1]);
        for (FactHandle factHandle : factHandles) {
            if (!(factHandle instanceof InternalFactHandle) || ((InternalFactHandle)factHandle).getId() != fhId) continue;
            InternalFactHandle fhClone = ((InternalFactHandle)factHandle).clone();
            if (this.disconnected) {
                fhClone.disconnect();
            }
            return fhClone;
        }
        return null;
    }

    public String toString() {
        return "ksession.getFactHandle( " + this.factHandleExternalForm + " );";
    }
}

