/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

public class BasicQueryBuilder
implements QueryBuilder<BasicQueryBuilder> {
    private boolean useWildcards = false;
    private final List<ValueIndexTerm> terms = new ArrayList<ValueIndexTerm>();

    public BasicQueryBuilder() {
        this(false);
    }

    public BasicQueryBuilder(boolean useWildcards) {
        this.useWildcards = useWildcards;
    }

    @Override
    public BasicQueryBuilder addTerm(ValueIndexTerm term) {
        this.terms.add(term);
        return this;
    }

    @Override
    public BasicQueryBuilder useWildcards() {
        this.useWildcards = true;
        return this;
    }

    @Override
    public Query build() {
        if (this.useWildcards) {
            return this.buildWildcardQuery();
        }
        return this.buildRegularQuery();
    }

    private Query buildWildcardQuery() {
        String field = this.buildField();
        String text = this.buildText();
        WildcardQuery query = new WildcardQuery(new Term(field, text));
        return query;
    }

    private Query buildRegularQuery() {
        BooleanQuery query = new BooleanQuery();
        String field = this.buildField();
        String text = this.buildText();
        query.add((Query)new TermQuery(new Term(field, text)), BooleanClause.Occur.MUST);
        return query;
    }

    private String buildField() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.terms.size() - 1; ++i) {
            ValueIndexTerm term = this.terms.get(i);
            sb.append(term.getTerm()).append(":").append(term.getValue()).append(":");
        }
        IndexTerm term = (IndexTerm)this.terms.get(this.terms.size() - 1);
        sb.append(term.getTerm());
        return sb.toString();
    }

    private String buildText() {
        ValueIndexTerm term = this.terms.get(this.terms.size() - 1);
        return term.getValue().toLowerCase();
    }
}

