/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster;

import java.util.HashMap;
import java.util.Map;
import org.uberfire.commons.cluster.LockExecuteNotifyAsyncReleaseTemplate;
import org.uberfire.commons.message.MessageType;
import org.uberfire.io.impl.cluster.ClusterMessageType;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class FileSystemSyncLock<V>
extends LockExecuteNotifyAsyncReleaseTemplate<V> {
    private final String serviceId;
    private final String scheme;
    private final String id;
    private final String uri;

    public FileSystemSyncLock(String serviceId, FileSystem _fileSystem) {
        FileSystem fileSystem = ((Path)_fileSystem.getRootDirectories().iterator().next()).getFileSystem();
        this.serviceId = serviceId;
        this.scheme = ((Path)fileSystem.getRootDirectories().iterator().next()).toUri().getScheme();
        this.id = ((FileSystemId)fileSystem).id();
        this.uri = fileSystem.toString();
    }

    public MessageType getMessageType() {
        return ClusterMessageType.SYNC_FS;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Map<String, String> buildContent() {
        return new HashMap<String, String>(){
            {
                this.put("fs_scheme", FileSystemSyncLock.this.scheme);
                this.put("fs_id", FileSystemSyncLock.this.id);
                this.put("fs_uri", FileSystemSyncLock.this.uri);
            }
        };
    }
}

