/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.sep;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.PerDocProducerBase;
import org.apache.lucene.codecs.lucene40.values.Bytes;
import org.apache.lucene.codecs.lucene40.values.Floats;
import org.apache.lucene.codecs.lucene40.values.Ints;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOUtils;

public class SepDocValuesProducer
extends PerDocProducerBase {
    private final TreeMap<String, DocValues> docValues;

    public SepDocValuesProducer(SegmentReadState state) throws IOException {
        this.docValues = this.load(state.fieldInfos, state.segmentInfo.name, state.segmentInfo.getDocCount(), state.dir, state.context);
    }

    protected Map<String, DocValues> docValues() {
        return this.docValues;
    }

    protected void closeInternal(Collection<? extends Closeable> closeables) throws IOException {
        IOUtils.close(closeables);
    }

    protected DocValues loadDocValues(int docCount, Directory dir, String id, DocValues.Type type, IOContext context) throws IOException {
        switch (type) {
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: 
            case FIXED_INTS_8: 
            case VAR_INTS: {
                return Ints.getValues((Directory)dir, (String)id, (int)docCount, (DocValues.Type)type, (IOContext)context);
            }
            case FLOAT_32: {
                return Floats.getValues((Directory)dir, (String)id, (int)docCount, (IOContext)context, (DocValues.Type)type);
            }
            case FLOAT_64: {
                return Floats.getValues((Directory)dir, (String)id, (int)docCount, (IOContext)context, (DocValues.Type)type);
            }
            case BYTES_FIXED_STRAIGHT: {
                return Bytes.getValues((Directory)dir, (String)id, (Bytes.Mode)Bytes.Mode.STRAIGHT, (boolean)true, (int)docCount, (Comparator)this.getComparator(), (IOContext)context);
            }
            case BYTES_FIXED_DEREF: {
                return Bytes.getValues((Directory)dir, (String)id, (Bytes.Mode)Bytes.Mode.DEREF, (boolean)true, (int)docCount, (Comparator)this.getComparator(), (IOContext)context);
            }
            case BYTES_FIXED_SORTED: {
                return Bytes.getValues((Directory)dir, (String)id, (Bytes.Mode)Bytes.Mode.SORTED, (boolean)true, (int)docCount, (Comparator)this.getComparator(), (IOContext)context);
            }
            case BYTES_VAR_STRAIGHT: {
                return Bytes.getValues((Directory)dir, (String)id, (Bytes.Mode)Bytes.Mode.STRAIGHT, (boolean)false, (int)docCount, (Comparator)this.getComparator(), (IOContext)context);
            }
            case BYTES_VAR_DEREF: {
                return Bytes.getValues((Directory)dir, (String)id, (Bytes.Mode)Bytes.Mode.DEREF, (boolean)false, (int)docCount, (Comparator)this.getComparator(), (IOContext)context);
            }
            case BYTES_VAR_SORTED: {
                return Bytes.getValues((Directory)dir, (String)id, (Bytes.Mode)Bytes.Mode.SORTED, (boolean)false, (int)docCount, (Comparator)this.getComparator(), (IOContext)context);
            }
        }
        throw new IllegalStateException("unrecognized index values mode " + type);
    }
}

