/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent.impl;

import java.util.Properties;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.core.util.StringUtils;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.drools.util.CompositeClassLoader;

public class KnowledgeAgentConfigurationImpl
implements KnowledgeAgentConfiguration {
    private static final KnowledgeAgentConfiguration defaultConf = new KnowledgeAgentConfigurationImpl();
    private ChainedProperties chainedProperties;
    private CompositeClassLoader classLoader;
    private boolean immutable = false;
    private boolean classLoaderCache = true;
    private boolean scanResources = true;
    private boolean scanDirectories = true;
    private boolean monitorChangeSetEvents = true;
    private boolean newInstance = true;
    private boolean useKBaseClassLoaderForCompiling = false;
    private int validationTimeout = 0;

    public static KnowledgeAgentConfiguration getDefaultInstance() {
        return defaultConf;
    }

    public KnowledgeAgentConfigurationImpl(Properties properties) {
        this.init(properties, null);
    }

    public KnowledgeAgentConfigurationImpl() {
        this.init(null, null);
    }

    public KnowledgeAgentConfigurationImpl(ClassLoader ... classLoaders) {
        this.init(null, classLoaders);
    }

    public KnowledgeAgentConfigurationImpl(Properties properties, ClassLoader ... classLoaders) {
        this.init(properties, classLoaders);
    }

    private void init(Properties properties, ClassLoader ... classLoaders) {
        this.immutable = false;
        this.setClassLoader(classLoaders);
        this.chainedProperties = new ChainedProperties("knowledgeagent.conf", this.classLoader, true);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setProperty("drools.agent.monitorChangeSetEvents", this.chainedProperties.getProperty("drools.agent.monitorChangeSetEvents", "true"));
        this.setProperty("drools.agent.scanDirectories", this.chainedProperties.getProperty("drools.agent.scanDirectories", "true"));
        this.setProperty("drools.agent.scanResources", this.chainedProperties.getProperty("drools.agent.scanResources", "true"));
        this.setProperty("drools.agent.newInstance", this.chainedProperties.getProperty("drools.agent.newInstance", "true"));
        this.setProperty("drools.agent.useKBaseClassLoaderForCompiling", this.chainedProperties.getProperty("drools.agent.useKBaseClassLoaderForCompiling", "false"));
        this.setProperty("drools.agent.validationTimeout", this.chainedProperties.getProperty("drools.agent.validationTimeout", "0"));
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.agent.monitorChangeSetEvents")) {
            this.setMonitorChangeSetEvents(StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value));
        } else if (name.equals("drools.agent.scanDirectories")) {
            boolean bool = StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value);
            this.setScanDirectories(bool);
            if (bool) {
                this.setScanResources(true);
                this.setMonitorChangeSetEvents(true);
            }
        } else if (name.equals("drools.agent.scanResources")) {
            boolean bool = StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value);
            this.setScanResources(bool);
            if (bool) {
                this.setMonitorChangeSetEvents(true);
            }
        } else if (name.equals("drools.agent.newInstance")) {
            this.setNewInstance(StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value));
        } else if (name.equals("drools.agent.useKBaseClassLoaderForCompiling")) {
            this.setUseKBaseClassLoaderForCompiling(StringUtils.isEmpty(value) ? false : Boolean.parseBoolean(value));
        } else if (name.equals("drools.agent.validationTimeout")) {
            try {
                int millisec = StringUtils.isEmpty(value) ? 0 : Integer.parseInt(value);
                this.setValidationTimeout(millisec);
            }
            catch (NumberFormatException nfe) {
                this.setValidationTimeout(0);
            }
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.agent.scanResources")) {
            return Boolean.toString(this.scanResources);
        }
        if (name.equals("drools.agent.scanDirectories")) {
            return Boolean.toString(this.scanDirectories);
        }
        if (name.equals("drools.agent.monitorChangeSetEvents")) {
            return Boolean.toString(this.monitorChangeSetEvents);
        }
        if (name.equals("drools.agent.newInstance")) {
            return Boolean.toString(this.newInstance);
        }
        if (name.equals("drools.agent.useKBaseClassLoaderForCompiling")) {
            return Boolean.toString(this.useKBaseClassLoaderForCompiling);
        }
        if (name.equals("drools.agent.validationTimeout")) {
            return Integer.toString(this.validationTimeout);
        }
        return null;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public CompositeClassLoader getClassLoader() {
        return this.classLoader.clone();
    }

    public void setClassLoader(ClassLoader ... classLoaders) {
        this.classLoader = ClassLoaderUtil.getClassLoader(classLoaders, this.getClass(), this.isClassLoaderCacheEnabled());
    }

    public boolean isClassLoaderCacheEnabled() {
        return this.classLoaderCache;
    }

    public void setClassLoaderCacheEnabled(boolean classLoaderCacheEnabled) {
        this.classLoaderCache = classLoaderCacheEnabled;
        this.classLoader.setCachingEnabled(this.classLoaderCache);
    }

    public boolean isScanResources() {
        return this.scanResources;
    }

    public void setScanResources(boolean scanResources) {
        this.scanResources = scanResources;
    }

    public boolean isScanDirectories() {
        return this.scanDirectories;
    }

    public void setScanDirectories(boolean scanDirectories) {
        this.scanDirectories = scanDirectories;
    }

    public boolean isMonitorChangeSetEvents() {
        return this.monitorChangeSetEvents;
    }

    public void setMonitorChangeSetEvents(boolean monitorChangeSetEvents) {
        this.monitorChangeSetEvents = monitorChangeSetEvents;
    }

    public boolean isNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(boolean newInstance) {
        this.newInstance = newInstance;
    }

    public boolean isUseKBaseClassLoaderForCompiling() {
        return this.useKBaseClassLoaderForCompiling;
    }

    public void setUseKBaseClassLoaderForCompiling(boolean useKBaseClassLoaderForCompiling) {
        this.useKBaseClassLoaderForCompiling = useKBaseClassLoaderForCompiling;
    }

    public int getValidationTimeout() {
        return this.validationTimeout;
    }

    public void setValidationTimeout(int validationTimeout) {
        this.validationTimeout = validationTimeout;
    }
}

