/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time;

public class Interval
implements Cloneable {
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    private long lowerBound;
    private long upperBound;

    public Interval() {
        this.lowerBound = Long.MIN_VALUE;
        this.upperBound = Long.MAX_VALUE;
    }

    public Interval(long lowerBound, long upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void intersect(Interval another) {
        this.lowerBound = Math.max(this.lowerBound, another.lowerBound);
        this.upperBound = Math.min(this.upperBound, another.upperBound);
    }

    public void add(Interval another) {
        this.lowerBound = this.lowerBound == Long.MIN_VALUE || another.lowerBound == Long.MIN_VALUE ? Long.MIN_VALUE : this.lowerBound + another.lowerBound;
        this.upperBound = this.upperBound == Long.MAX_VALUE || another.upperBound == Long.MAX_VALUE ? Long.MAX_VALUE : this.upperBound + another.upperBound;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public Interval clone() {
        return new Interval(this.lowerBound, this.upperBound);
    }

    public String toString() {
        String result = "[ " + (this.lowerBound == Long.MIN_VALUE ? "-NA" : Long.valueOf(this.lowerBound)) + ", " + (this.upperBound == Long.MAX_VALUE ? " NA" : Long.valueOf(this.upperBound)) + " ]";
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lowerBound ^ this.lowerBound >>> 32);
        result = 31 * result + (int)(this.upperBound ^ this.upperBound >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.lowerBound != other.lowerBound) {
            return false;
        }
        return this.upperBound == other.upperBound;
    }
}

