/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeKind;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType;

public class JavaClassImpl
extends AbstractJavaType
implements JavaClass {
    private String superClassName;
    private List<String> interfaces = new ArrayList<String>();
    boolean _static = false;
    boolean _final = false;
    boolean _abstract = false;

    public JavaClassImpl() {
    }

    public JavaClassImpl(String packageName, String name) {
        this(packageName, name, Visibility.PUBLIC);
    }

    public JavaClassImpl(String packageName, String name, Visibility visibility) {
        super(packageName, name, JavaTypeKind.CLASS, visibility);
    }

    public JavaClassImpl(String packageName, String name, Visibility visibility, boolean isAbstract, boolean isFinal) {
        this(packageName, name, visibility);
        this._abstract = isAbstract;
        this._final = isFinal;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isFinal() {
        return this._final;
    }

    @Override
    public boolean isStatic() {
        return this._static;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    @Override
    public final boolean isClass() {
        return true;
    }

    @Override
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaClassImpl javaClass = (JavaClassImpl)o;
        if (this._static != javaClass._static) {
            return false;
        }
        if (this._final != javaClass._final) {
            return false;
        }
        if (this._abstract != javaClass._abstract) {
            return false;
        }
        if (this.superClassName != null ? !this.superClassName.equals(javaClass.superClassName) : javaClass.superClassName != null) {
            return false;
        }
        return !(this.interfaces == null ? javaClass.interfaces != null : !this.interfaces.equals(javaClass.interfaces));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.superClassName != null ? this.superClassName.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.interfaces != null ? this.interfaces.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this._static ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this._final ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this._abstract ? 1 : 0);
        result = ~(~result);
        return result;
    }
}

