/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.git.GitRepositoryBuilder;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.io.IOService;

@ApplicationScoped
public class GitRepositoryFactoryHelper
implements RepositoryFactoryHelper {
    private IOService ioService;
    @Inject
    private PasswordService secureService;

    public GitRepositoryFactoryHelper() {
    }

    @Inject
    public GitRepositoryFactoryHelper(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public boolean accept(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return "git".equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        this.validate(repoConfig);
        return new GitRepositoryBuilder(this.ioService, this.secureService).build(repoConfig);
    }

    private void validate(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
    }
}

