/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.MultiViewRow;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.widgets.VersionChooser;
import org.drools.guvnor.client.widgets.query.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.DependenciesPagedTable;

public class DependencyWidget
extends Composite {
    private DependenciesPagedTable table;
    private Module conf;
    private boolean isHistoricalReadOnly = false;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public DependencyWidget(ClientFactory clientFactory, EventBus eventBus, Module conf, boolean isHistoricalReadOnly) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.conf = conf;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        FormStyleLayout layout = new FormStyleLayout();
        VerticalPanel header = new VerticalPanel();
        Label caption = new Label("Dependencies");
        caption.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        header.add((Widget)caption);
        header.add(this.dependencyTip());
        layout.addAttribute("", (Widget)header);
        VerticalPanel vp = new VerticalPanel();
        vp.setHeight("100%");
        vp.setWidth("100%");
        layout.addRow((Widget)vp);
        this.table = new DependenciesPagedTable(conf.getUuid(), new OpenItemCommand(){

            @Override
            public void open(String path) {
                DependencyWidget.this.showEditor(path);
            }

            @Override
            public void open(MultiViewRow[] rows) {
            }
        });
        layout.addRow((Widget)this.table);
        this.initWidget((Widget)layout);
    }

    private Widget dependencyTip() {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new HTML("<small><i>This shows exact versions of assets that this package contains.</i></small>"));
        InfoPopup pop = new InfoPopup("Edit Dependency", "Edit dependency version to build a package against specific versions of assets");
        hp.add((Widget)pop);
        return hp;
    }

    public static String[] decodeDependencyPath(String dependencyPath) {
        if (dependencyPath.indexOf("?version=") >= 0) {
            return dependencyPath.split("\\?version=");
        }
        return new String[]{dependencyPath, "LATEST"};
    }

    public static String encodeDependencyPath(String dependencyPath, String dependencyVersion) {
        return dependencyPath + "?version=" + dependencyVersion;
    }

    private void showEditor(final String dependencyPath) {
        Image image = new Image(ImagesCore.INSTANCE.management());
        image.setAltText(ConstantsCore.INSTANCE.Management());
        final FormStylePopup editor = new FormStylePopup(image, "Edit Dependency");
        editor.addAttribute("Dependency Path: ", (Widget)new Label(DependencyWidget.decodeDependencyPath(dependencyPath)[0]));
        final VersionChooser versionChoose = new VersionChooser(this.clientFactory, this.eventBus, DependencyWidget.decodeDependencyPath(dependencyPath)[1], this.conf.getUuid(), DependencyWidget.decodeDependencyPath(dependencyPath)[0], new Command(){

            public void execute() {
                DependencyWidget.this.table.refresh();
            }
        });
        editor.addAttribute("Dependency Version: ", (Widget)versionChoose);
        HorizontalPanel hp = new HorizontalPanel();
        Button useSelectedVersionButton = new Button("Use selected version");
        hp.add((Widget)useSelectedVersionButton);
        useSelectedVersionButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String selectedVersion = versionChoose.getSelectedVersionName();
                if (selectedVersion == null) {
                    return;
                }
                if (Window.confirm((String)("Are you sure you want to use version: " + selectedVersion + " as dependency?"))) {
                    ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                    moduleService.updateDependency(DependencyWidget.this.conf.getUuid(), DependencyWidget.encodeDependencyPath(DependencyWidget.decodeDependencyPath(dependencyPath)[0], selectedVersion), new GenericCallback<Void>(){

                        public void onSuccess(Void v) {
                            editor.hide();
                            DependencyWidget.this.table.refresh();
                        }
                    });
                }
            }
        });
        useSelectedVersionButton.setEnabled(!this.isHistoricalReadOnly);
        Button cancel = new Button(ConstantsCore.INSTANCE.Cancel());
        hp.add((Widget)cancel);
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                editor.hide();
            }
        });
        editor.addAttribute("", (Widget)hp);
        editor.show();
    }
}

