/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.repository.AssetItem;

public abstract class PlainTextContentHandler
extends ContentHandler {
    @Override
    public void retrieveAssetContent(Asset asset, AssetItem item) throws SerializationException {
        RuleContentText text = new RuleContentText();
        text.content = item.getContent();
        asset.setContent(text);
    }

    @Override
    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
        repoAsset.updateContent(((RuleContentText)asset.getContent()).content);
    }

    public BuilderResult validateAsset(AssetItem asset) {
        String message = this.validate(asset.getContent());
        return this.createBuilderResult(message, asset.getName(), asset.getFormat(), asset.getUUID());
    }

    private BuilderResult createBuilderResult(String message, String name, String format, String uuid) {
        if (message.length() == 0) {
            return new BuilderResult();
        }
        ArrayList<BuilderResultLine> errors = new ArrayList<BuilderResultLine>();
        BuilderResultLine result = new BuilderResultLine().setAssetName(name).setAssetFormat(format).setUuid(uuid).setMessage(message);
        errors.add(result);
        BuilderResult builderResult = new BuilderResult();
        builderResult.addLines(errors);
        return builderResult;
    }

    public String validate(String content) {
        return "";
    }
}

