/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.builder.ModuleAssembler;
import org.drools.guvnor.server.builder.ModuleAssemblerManager;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.repository.FileUploadedEvent;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.annotations.LoggedIn;

@Named(value="fileManager")
@ApplicationScoped
public class FileManagerService {
    @Inject
    @Preferred
    private RulesRepository repository;
    @Inject
    private Identity identity;
    @Inject
    @Any
    private Event<FileUploadedEvent> fileUploadedEventEvent;

    @LoggedIn
    public void attachFile(FormData uploadItem) throws IOException {
        String uuid = uploadItem.getUuid();
        InputStream fileData = uploadItem.getFile().getInputStream();
        String fileName = uploadItem.getFile().getName();
        this.attachFileToAsset(uuid, fileData, fileName);
        uploadItem.getFile().getInputStream().close();
    }

    @LoggedIn
    public void attachFileToAsset(String uuid, InputStream fileData, String fileName) throws IOException {
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        item.updateBinaryContentAttachment(fileData);
        item.updateBinaryContentAttachmentFileName(fileName);
        item.getModule().updateBinaryUpToDate(false);
        item.checkin("Attached file: " + fileName);
        ContentHandler handler = ContentManager.getHandler(item.getFormat());
        if (handler instanceof ICanHasAttachment) {
            ((ICanHasAttachment)((Object)handler)).onAttachmentAdded(item);
        }
    }

    public void setRepository(RulesRepository repository) {
        this.repository = repository;
    }

    @LoggedIn
    public String loadFileAttachmentByUUID(String uuid, OutputStream out) throws IOException {
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        byte[] data = item.getBinaryContentAsBytes();
        if (data == null) {
            data = new byte[]{};
        }
        out.write(data);
        out.flush();
        String fileName = null;
        String binaryContentAttachmentFileName = item.getBinaryContentAttachmentFileName();
        fileName = binaryContentAttachmentFileName != null && !"".equals(binaryContentAttachmentFileName) ? binaryContentAttachmentFileName : item.getName() + "." + item.getFormat();
        return fileName;
    }

    public static FormData getFormData(HttpServletRequest request) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        FormData data = new FormData();
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField() && item.getFieldName().equals("attachmentUUID")) {
                    data.setUuid(item.getString());
                    continue;
                }
                if (item.isFormField()) continue;
                data.setFile(item);
            }
            return data;
        }
        catch (FileUploadException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    public String loadBinaryPackage(String packageName, String packageVersion, boolean isLatest, OutputStream out) throws IOException {
        ModuleItem item = null;
        if (isLatest) {
            item = this.repository.loadModule(packageName);
            byte[] data = item.getCompiledBinaryBytes();
            out.write(data);
            out.flush();
            return packageName + ".pkg";
        }
        item = this.repository.loadModuleSnapshot(packageName, packageVersion);
        byte[] data = item.getCompiledBinaryBytes();
        out.write(data);
        out.flush();
        return packageName + "_" + URLEncoder.encode(packageVersion, "UTF-8") + ".pkg";
    }

    public String loadSourcePackage(String packageName, String packageVersion, boolean isLatest, OutputStream out) throws IOException {
        ModuleItem item = null;
        if (isLatest) {
            item = this.repository.loadModule(packageName);
            ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, null);
            String drl = moduleAssembler.getCompiledSource();
            out.write(drl.getBytes());
            out.flush();
            return packageName + ".drl";
        }
        item = this.repository.loadModuleSnapshot(packageName, packageVersion);
        ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, null);
        String drl = moduleAssembler.getCompiledSource();
        out.write(drl.getBytes());
        out.flush();
        return packageName + "_" + URLEncoder.encode(packageVersion, "UTF-8") + ".drl";
    }

    public byte[] exportPackageFromRepository(String packageName) {
        try {
            return this.repository.exportModuleFromRepository(packageName);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    public boolean isPackageExist(String packageName) {
        return this.repository.containsModule(packageName);
    }

    public void exportRulesRepository(OutputStream out) {
        this.repository.exportRepositoryToStream(out);
    }

    @LoggedIn
    public void importRulesRepository(InputStream in) {
        this.identity.checkPermission((Object)new AdminType(), RoleType.ADMIN.getName());
        this.repository.importRulesRepositoryFromStream(in);
        this.fileUploadedEventEvent.fire((Object)new FileUploadedEvent());
    }

    @LoggedIn
    public void importPackageToRepository(byte[] data, boolean importAsNew) {
        this.repository.importPackageToRepository(data, importAsNew);
        this.fileUploadedEventEvent.fire((Object)new FileUploadedEvent());
    }

    @LoggedIn
    public String importClassicDRL(InputStream drlInputStream, String packageName) {
        ClassicDRLImporter imp;
        try {
            imp = new ClassicDRLImporter(drlInputStream);
        }
        catch (DroolsParserException e) {
            throw new IllegalArgumentException("Could not parse the drlInputStream for package (" + packageName + "): " + e.getMessage(), e);
        }
        ModuleItem pkg = null;
        if (packageName == null) {
            packageName = imp.getPackageName();
        }
        if (packageName == null || "".equals(packageName)) {
            throw new IllegalArgumentException("Missing package name.");
        }
        boolean existing = this.repository.containsModule(packageName);
        if (existing && this.repository.isModuleArchived(packageName)) {
            ModuleItem item = this.repository.loadModule(packageName);
            item.remove();
            existing = false;
        }
        if (existing) {
            pkg = this.repository.loadModule(packageName);
            DroolsHeader.updateDroolsHeader(ClassicDRLImporter.mergeLines(DroolsHeader.getDroolsHeader(pkg), imp.getPackageHeader()), pkg);
            existing = true;
        } else {
            pkg = this.repository.createModule(packageName, "<imported>");
            DroolsHeader.updateDroolsHeader(imp.getPackageHeader(), pkg);
        }
        boolean newVer = Boolean.parseBoolean(System.getProperty("drools.createNewVersionOnImport", "true"));
        for (ClassicDRLImporter.Asset as : imp.getAssets()) {
            AssetItem asset;
            if (existing && pkg.containsAsset(as.name)) {
                asset = pkg.loadAsset(as.name);
                if (!asset.getFormat().equals(as.format)) continue;
                asset.updateContent(as.content);
                if (!newVer) continue;
                asset.checkin("Imported change from external DRL");
                continue;
            }
            asset = pkg.addAsset(as.name, "<imported>");
            asset.updateFormat(as.format);
            asset.updateContent(as.content);
            asset.updateExternalSource("Imported from external DRL");
            if (!newVer) continue;
            asset.checkin("Imported change from external DRL");
        }
        pkg.updateBinaryUpToDate(false);
        this.repository.save();
        return packageName;
    }

    public long getLastModified(String name, String version) {
        ModuleItem item = null;
        item = version.equals("LATEST") ? this.repository.loadModule(name) : this.repository.loadModuleSnapshot(name, version);
        return item.getLastModified().getTimeInMillis();
    }

    public String loadSourceAsset(String packageName, String packageVersion, boolean isLatest, String assetName, ByteArrayOutputStream out) throws IOException {
        ModuleItem pkg = null;
        pkg = isLatest ? this.repository.loadModule(packageName) : this.repository.loadModuleSnapshot(packageName, packageVersion);
        AssetItem item = pkg.loadAsset(assetName);
        ContentHandler handler = ContentManager.getHandler(item.getFormat());
        StringBuilder stringBuilder = new StringBuilder();
        if (handler.isRuleAsset()) {
            BRMSPackageBuilder builder = new BRMSPackageBuilder();
            builder.setDSLFiles(DSLLoader.loadDSLMappingFiles(item.getModule()));
            ((IRuleAsset)((Object)handler)).assembleDRL(builder, item, stringBuilder);
            out.write(stringBuilder.toString().getBytes());
            return item.getName() + ".drl";
        }
        out.write(item.getContent().getBytes());
        return item.getName() + ".drl";
    }
}

