/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.Serializable;
import javax.inject.Inject;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.Credentials;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoAuthenticator
extends BaseAuthenticator
implements Serializable {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private Credentials credentials;
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;

    public void authenticate() {
        this.upgradeGuestToAdmin();
        String username = this.credentials.getUsername();
        Credential credential = this.credentials.getCredential();
        if (username == null || !(credential instanceof PasswordCredential)) {
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
            this.log.info("Demo login for user (" + username + ") failed: unsupported username/credential.");
            return;
        }
        PasswordCredential passwordCredential = (PasswordCredential)this.credentials.getCredential();
        if (!username.equals(passwordCredential.getValue())) {
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
            this.log.info("Demo login for user (" + username + ") failed: wrong username/password.");
            return;
        }
        this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
        this.setUser((User)new SimpleUser(username));
        this.log.info("Demo login for user (" + username + ") succeeded.");
    }

    private void upgradeGuestToAdmin() {
        if (this.credentials.getUsername() != null && this.credentials.getUsername().equals("guest")) {
            this.credentials.setUsername("admin");
            this.credentials.setCredential((Credential)new PasswordCredential("admin"));
        }
    }
}

