/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportXmlUtils {
    private static final String CDATA_SECTION = "#cdata-section";

    public static String formatCdataSection(String content) {
        StringBuilder sb = new StringBuilder("<![CDATA[");
        sb.append(ExportXmlUtils.escapeContent(content)).append("]]>");
        return sb.toString();
    }

    public static String formatMap(Map<String, String> map) {
        StringBuilder sb = new StringBuilder("<map>");
        if (map != null && map.size() > 0) {
            Iterator<Map.Entry<String, String>> mapEntryIt = map.entrySet().iterator();
            while (mapEntryIt.hasNext()) {
                sb.append("<entry>");
                Map.Entry<String, String> entry = mapEntryIt.next();
                sb.append("<key>").append(ExportXmlUtils.escapeXml(entry.getKey())).append("</key>");
                sb.append("<value>").append(ExportXmlUtils.escapeXml(entry.getValue())).append("</value>");
                sb.append("</entry>");
            }
        }
        sb.append("</map>");
        return sb.toString();
    }

    public static String parseCdataSection(Node cdataParentNode) {
        if (cdataParentNode == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        NodeList cdataParentNodeChildren = cdataParentNode.getChildNodes();
        if (cdataParentNodeChildren != null && cdataParentNodeChildren.getLength() > 0) {
            for (int i = 0; i < cdataParentNodeChildren.getLength(); ++i) {
                Node cdataNode = cdataParentNodeChildren.item(i);
                if (CDATA_SECTION.equalsIgnoreCase(cdataNode.getNodeName())) {
                    sb.append(cdataNode.getTextContent());
                    continue;
                }
                System.out.println("WARNING: only expected CData sections, ignoring: " + cdataNode.getNodeName());
            }
        }
        return sb.toString();
    }

    public static Map<String, String> parseMap(Node mapNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapNode != null && "map".equals(mapNode.getNodeName())) {
            NodeList entriesNodes = mapNode.getChildNodes();
            for (int i = 0; i < entriesNodes.getLength(); ++i) {
                Node entriesNode = entriesNodes.item(i);
                NodeList entry = entriesNode.getChildNodes();
                String key = null;
                String value = null;
                for (int j = 0; j < entry.getLength(); ++j) {
                    Node keyValueNode = entry.item(j);
                    if ("key".equals(keyValueNode.getNodeName())) {
                        key = ExportXmlUtils.unEscapeXml(keyValueNode.getTextContent());
                        continue;
                    }
                    if (!"value".equals(keyValueNode.getNodeName())) continue;
                    value = ExportXmlUtils.unEscapeXml(keyValueNode.getTextContent());
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static String escapeXml(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }

    public static String unEscapeXml(String s) {
        return StringEscapeUtils.unescapeXml((String)s);
    }

    private static String escapeContent(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        return s.replaceAll("]]>", "]]]]><![CDATA[>");
    }
}

