/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.manager;

import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RuntimeManagerFactory {
    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment var1);

    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment var1, String var2);

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment var1);

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment var1, String var2);

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment var1);

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment var1, String var2);

    public static class Factory {
        private static boolean initialized = false;
        private static RuntimeManagerFactory INSTANCE;
        private static Logger logger;

        public static RuntimeManagerFactory get() {
            return Factory.get(null);
        }

        public static synchronized RuntimeManagerFactory get(ClassLoader classLoader) {
            if (!initialized) {
                INSTANCE = Factory.create(classLoader);
            } else if (INSTANCE == null) {
                throw new RuntimeException("RuntimeManagerFactory was not initialized, see previous errors");
            }
            return INSTANCE;
        }

        private static RuntimeManagerFactory create(ClassLoader classLoader) {
            initialized = true;
            try {
                String className = System.getProperty("org.jbpm.runtime.manager.class", "org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl");
                return classLoader != null ? (RuntimeManagerFactory)Class.forName(className, true, classLoader).newInstance() : (RuntimeManagerFactory)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.error("Unable to instance RuntimeManagerFactory due to " + e.getMessage());
                return null;
            }
        }

        static {
            logger = LoggerFactory.getLogger(Factory.class);
        }
    }
}

