/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorBuildService;
import org.uberfire.backend.vfs.Path;

public class Validator {
    private final ProjectService projectService;
    private final BuildService buildService;

    public Validator(ProjectService projectService, BuildService buildService) {
        this.projectService = projectService;
        this.buildService = buildService;
    }

    public List<ValidationMessage> validate(Path path, String content) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : this.validatorBuildService().validate(path, content)) {
            if (!this.isValidatPath(path, message)) continue;
            messages.add(message);
        }
        return messages;
    }

    private ValidatorBuildService validatorBuildService() {
        return new ValidatorBuildService(this.projectService, this.buildService);
    }

    protected boolean isValidatPath(Path path, ValidationMessage message) {
        String destinationPathURI = this.removeFileExtension(path.toURI());
        String messageURI = message.getPath() != null ? this.removeFileExtension(message.getPath().toURI()) : "";
        return messageURI.isEmpty() || destinationPathURI.endsWith(messageURI);
    }

    private String removeFileExtension(String pathURI) {
        if (pathURI != null && pathURI.contains(".")) {
            return pathURI.substring(0, pathURI.lastIndexOf("."));
        }
        return pathURI;
    }
}

