/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.backend.validation.asset.NoProjectException;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorResultBuilder;
import org.uberfire.backend.vfs.Path;

public class ValidatorBuildService {
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found. Consequentially validation cannot be performed.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private final BuildService buildService;
    private final ProjectService projectService;

    public ValidatorBuildService(ProjectService projectService, BuildService buildService) {
        this.projectService = projectService;
        this.buildService = buildService;
    }

    public List<ValidationMessage> validate(Path resourcePath, String content) {
        try {
            List<ValidationMessage> results = this.buildIncrementally(resourcePath, content);
            return results;
        }
        catch (NoProjectException e) {
            return new ArrayList<ValidationMessage>();
        }
        catch (NoClassDefFoundError e) {
            return this.error(MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage()));
        }
        catch (Throwable e) {
            return this.error(e.getLocalizedMessage());
        }
    }

    private List<ValidationMessage> buildIncrementally(Path resourcePath, String content) throws NoProjectException {
        ValidatorResultBuilder resultBuilder = new ValidatorResultBuilder();
        if (this.incrementalBuild(resourcePath)) {
            resultBuilder.add(this.buildService.updatePackageResource(resourcePath, content).getAddedMessages());
        } else {
            resultBuilder.add(this.buildService.build(this.project(resourcePath), resourcePath, content).getMessages());
        }
        return resultBuilder.results();
    }

    private boolean incrementalBuild(Path resourcePath) throws NoProjectException {
        boolean alreadyBuilt = this.buildService.isBuilt(this.project(resourcePath));
        boolean isResource = this.getDestinationPath(resourcePath).startsWith("src/main/resources/");
        return alreadyBuilt && isResource;
    }

    private String getDestinationPath(Path path) throws NoProjectException {
        int rootPathLength = this.project(path).getRootPath().toURI().length() + 1;
        return path.toURI().toString().substring(rootPathLength);
    }

    private Project project(Path resourcePath) throws NoProjectException {
        Project project = this.projectService.resolveProject(resourcePath);
        if (project == null) {
            throw new NoProjectException();
        }
        return project;
    }

    private ArrayList<ValidationMessage> error(final String errorMessage) {
        return new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage(Level.ERROR, errorMessage));
            }
        };
    }
}

